var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$table = $('#tablaDatos');
	
	consultarClientes();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	
		//Iniciamos Fechas
	$('input[id$=txtFechaCorte]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false,	
		closeOnDateSelect: true	
    });


	$('#ddlPaises').on('change', function (e) {

		var vClavePais = $("#ddlPaises").val();
		
		if(parseInt(vClavePais) === 151){
			$("#txtTrib").attr("disabled",true);
			$("#txtTrib").val("0");
		}else{					
			$("#txtTrib").attr("disabled",false);
			$("#txtTrib").val("");
		}
		
		if(parseInt(vClavePais) === 40 || parseInt(vClavePais) === 66){
			$("#lblIdTrib").text("ID TRIB (Deben ser 9 caracteres)");
		}else{
			if(parseInt(vClavePais) != 40 && parseInt(vClavePais) != 66 && parseInt(vClavePais) != 151){
				$("#lblIdTrib").text("ID TRIB (Maximo 40 caracteres)");
			}
		}
	});



});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	
	consultarUsoCfdi();
	consultarMetodoPago();
	consultarFormasPago();
	consultarCatPaises();
	
	$("#popupDetalleCliente").modal("show");		
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {			

			console.log(resp);

			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				columns: [
					{ "data": "nombrecorto" },
					{ "data": "razonsocial" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
	});
}

function guardar(){
	
	var vRazonSocial = $("#txtRazonSocial").val();
	var vNombreCorto = $("#txtNombreCorto").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vContacto = $("#txtContacto").val();
	var vCorreo = $("#txtCorreo").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	var vDescuento = $("#txtDescuento").val();
	var vComision = $("#txtComision").val();
	
	var vTipoFacturacion = $("#ddlTipoFacturacion").val();
	var vFechaCorte = $("#txtFechaCorte").val();
	var vUsoCfdi = $("#ddlUsoCFDI").val();
	var vMetodoPago = $("#ddlMetodoPago").val();
	var vFormaPago = $("#ddlFormasPago").val();
	var vEtiquetaBuque = $("#txtEtiquetaBuque").val();
	var vEtiquetaViaje = $("#txtEtiquetaViaje").val();

	var vClavePais = $("#ddlPaises").val();
	var vIdTrip = $("#txtTrib").val();
	var vClaveEstado = $("#txtEstado").val();
	var vClaveMunicipio = $("#txtMunicipios").val();
	var vClaveLocalidad = $("#txtLocalidad").val();
	var vClaveColonia = $("#txtColonia").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"            
            ,vRazonSocial:vRazonSocial
            ,vNombreCorto:vNombreCorto
            ,vRfc:vRfc
            ,vDomicilio:vDomicilio
            ,vContacto: vContacto			
			,vCorreo: vCorreo
			,vNoExterior: vNoExterior
			,vNoInterior: vNoInterior
			,vCp: vCp
			,vTelefono: vTelefono
			,vDescuento: vDescuento
			,vComision: vComision
			,vTipoFacturacion:vTipoFacturacion
			,vFechaCorte:vFechaCorte
			,vUsoCfdi:vUsoCfdi
			,vMetodoPago:vMetodoPago
			,vFormaPago:vFormaPago
			,vEtiquetaBuque:vEtiquetaBuque
			,vEtiquetaViaje:vEtiquetaViaje
			,vClavePais:vClavePais
			,vIdTrip:vIdTrip
			,vClaveEstado:vClaveEstado
			,vClaveMunicipio:vClaveMunicipio
			,vClaveLocalidad:vClaveLocalidad
			,vClaveColonia:vClaveColonia
        };

        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catClientes.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultarClientes();
				$("#popupDetalleCliente").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var vNid = $("#hfIdSeleccionado").val();
	var vRazonSocial = $("#txtRazonSocial").val();
	var vNombreCorto = $("#txtNombreCorto").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vContacto = $("#txtContacto").val();
	var vCorreo = $("#txtCorreo").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	var vDescuento = $("#txtDescuento").val();
	var vComision = $("#txtComision").val();
	
	var vTipoFacturacion = $("#ddlTipoFacturacion").val();
	var vFechaCorte = $("#txtFechaCorte").val();
	var vUsoCfdi = $("#ddlUsoCFDI").val();
	var vMetodoPago = $("#ddlMetodoPago").val();
	var vFormaPago = $("#ddlFormasPago").val();

	var vEtiquetaBuque = $("#txtEtiquetaBuque").val();
	var vEtiquetaViaje = $("#txtEtiquetaViaje").val();

	var vClavePais = $("#ddlPaises").val();
	var vIdTrip = $("#txtTrib").val();
	var vClaveEstado = $("#txtEstado").val();
	var vClaveMunicipio = $("#txtMunicipios").val();
	var vClaveLocalidad = $("#txtLocalidad").val();
	var vClaveColonia = $("#txtColonia").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,vNid:vNid
            ,vRazonSocial:vRazonSocial
            ,vNombreCorto:vNombreCorto
            ,vRfc:vRfc
            ,vDomicilio:vDomicilio
            ,vContacto: vContacto			
			,vCorreo: vCorreo
			,vNoExterior: vNoExterior
			,vNoInterior: vNoInterior
			,vCp: vCp
			,vTelefono: vTelefono
			,vDescuento: vDescuento
			,vComision: vComision
			,vTipoFacturacion:vTipoFacturacion
			,vFechaCorte:vFechaCorte
			,vUsoCfdi:vUsoCfdi
			,vMetodoPago:vMetodoPago
			,vFormaPago:vFormaPago
			,vEtiquetaBuque:vEtiquetaBuque
			,vEtiquetaViaje:vEtiquetaViaje
			,vClavePais:vClavePais
			,vIdTrip:vIdTrip
			,vClaveEstado:vClaveEstado
			,vClaveMunicipio:vClaveMunicipio
			,vClaveLocalidad:vClaveLocalidad
			,vClaveColonia:vClaveColonia
        };

		console.log("actualiza");
		console.log(json_request);
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catClientes.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultarClientes();
				$("#popupDetalleCliente").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "El cliente serĂ¡ dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/catClientes.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultarClientes();
						$("#popupDetalleCliente").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}

function verDetalle(pNid){
	
	consultarUsoCfdi();
	consultarMetodoPago();
	consultarFormasPago();
	
	
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	

			console.log("respuesta consulta X ID");
			console.log(resp);

			$("#txtRazonSocial").val(resp.datos[0].razonsocial);
			$("#txtNombreCorto").val(resp.datos[0].nombrecorto);
			$("#txtRfc").val(resp.datos[0].rfc);
			$("#txtDomicilio").val(resp.datos[0].domicilio);
			$("#txtContacto").val(resp.datos[0].contacto);
			$("#txtCorreo").val(resp.datos[0].correo);
			$("#txtNoExterior").val(resp.datos[0].exterior);	
			$("#txtNoInterior").val(resp.datos[0].interior);
			$("#txtCp").val(resp.datos[0].cp);
			$("#txtTelefono").val(resp.datos[0].telefono);
			$("#txtDescuento").val(resp.datos[0].descuento);
			$("#txtComision").val(resp.datos[0].comision);	

			$("#ddlTipoFacturacion").val(resp.datos[0].tipoFacturacion);
			$("#txtFechaCorte").val(resp.datos[0].fechaCorte);
			$("#ddlUsoCFDI").val(resp.datos[0].usoCfdi);
			$("#ddlMetodoPago").val(resp.datos[0].metodoPago);
			$("#ddlFormasPago").val(resp.datos[0].formaPago);

			$("#txtEtiquetaBuque").val(resp.datos[0].etiquetaBuque);
			$("#txtEtiquetaViaje").val(resp.datos[0].etiquetaViaje);

			consultarCatPaises();
			$("#ddlPaises").val(resp.datos[0].clavePais);
			$("#txtTrib").val(resp.datos[0].idTrip);

			$("#txtEstado").val(resp.datos[0].claveEstado);
			$("#txtMunicipios").val(resp.datos[0].claveMunicipio);
			$("#txtLocalidad").val(resp.datos[0].claveLocalidad);
			$("#txtColonia").val(resp.datos[0].claveColonia);
	
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalleCliente").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vRazonSocial = $("#txtRazonSocial").val();
	var vNombreCorto = $("#txtNombreCorto").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vContacto = $("#txtContacto").val();
	var vCorreo = $("#txtCorreo").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	var vDescuento = $("#txtDescuento").val();
	var vComision = $("#txtComision").val();
	
	var vTipoFacturacion = $("#ddlTipoFacturacion").val();
	var vFechaCorte = $("#txtFechaCorte").val();
	var vUsoCfdi = $("#ddlUsoCFDI").val();
	var vMetodoPago = $("#ddlMetodoPago").val();
	var vFormaPago = $("#ddlFormasPago").val();

	var vEtiquetaBuque = $("#txtEtiquetaBuque").val();
	var vEtiquetaViaje = $("#txtEtiquetaViaje").val();

	var vClavePais = $("#ddlPaises").val();
	var vIdTrip = $("#txtTrib").val();
	var vClaveEstado = $("#txtEstado").val();
	var vClaveMunicipio = $("#txtMunicipios").val();
	var vClaveLocalidad = $("#txtLocalidad").val();
	var vClaveColonia = $("#txtColonia").val();
	
	//Si es pais MEXICO no validar Estado,Municipio, Localidad, Colonia
	if(parseInt(vClavePais) === 151){
        	if(vClaveEstado.length === 0){
        		$("#txtEstado").addClass('campo-requerido');
        	   	respuesta=false;
           	}
        
        	if(vClaveMunicipio.length === 0){
        		$("#txtMunicipios").addClass('campo-requerido');
        	   	respuesta=false;
           	}
        
        	if(vClaveLocalidad.length === 0){
        		$("#txtLocalidad").addClass('campo-requerido');
        	   	respuesta=false;
           	}
        
        	if(vClaveColonia.length === 0){
        		$("#txtColonia").addClass('campo-requerido');
        	   	respuesta=false;
           	}
	}

	if(parseInt(vClavePais) === -1){
        $("#ddlPaises").addClass('campo-requerido');
        respuesta=false;
    }else{
		if(vIdTrip.length === 0){
			$("#txtTrib").addClass('campo-requerido');
			   respuesta=false;
		}else{
			if(parseInt(vClavePais) === 40 || parseInt(vClavePais) === 66){
				if(vIdTrip.length != 9){
					$("#lblIdTrib").text("ID TRIB (Deben ser 9 caracteres)");
					$("#txtTrib").addClass('campo-requerido');
					   respuesta=false;
				}
			}else{
				if(parseInt(vClavePais) != 40 && parseInt(vClavePais) != 66 && parseInt(vClavePais) != 151){
					if(vIdTrip.length > 40){
						$("#lblIdTrib").text("ID TRIB (Maximo 40 caracteres)");
						$("#txtTrib").addClass('campo-requerido');
						   respuesta=false;
					}
				}
			}
		}
	}

	if(vEtiquetaViaje.length === 0){
		$("#txtEtiquetaViaje").addClass('campo-requerido');
	   	respuesta=false;
   	}

	if(vEtiquetaBuque.length === 0){
		$("#txtEtiquetaBuque").addClass('campo-requerido');
	   	respuesta=false;
   	}
	
	if(vFechaCorte.length === 0){
         $("#txtFechaCorte").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vFormaPago) === -1){
        $("#ddlFormasPago").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vMetodoPago) === -1){
        $("#ddlMetodoPago").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vTipoFacturacion) === -1){
        $("#ddlTipoFacturacion").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vUsoCfdi) === -1){
        $("#ddlUsoCFDI").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vRazonSocial.length === 0){
         $("#txtRazonSocial").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNombreCorto.length === 0){
         $("#txtNombreCorto").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vCorreo.length === 0){
         $("#txtCorreo").addClass('campo-requerido');
        respuesta=false;
    }else{
        
         expr = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        if ( !expr.test(vCorreo) ){
             $("#txtCorreo").addClass('campo-requerido');
            respuesta=false;
        }
        
    }
	
	if(vContacto.length === 0){
         $("#txtContacto").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vDomicilio.length === 0){
         $("#txtDomicilio").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vRfc.length === 0){
         $("#txtRfc").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(vComision.length === 0){
         $("#txtComision").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vDescuento.length === 0){
         $("#txtDescuento").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vTelefono.length === 0){
         $("#txtTelefono").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vCp.length === 0){
         $("#txtCp").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNoExterior.length === 0){
         $("#txtNoExterior").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNoInterior.length === 0){
         $("#txtNoInterior").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}

function limpiarCampos(){
	$("#txtRazonSocial").val("");
	$("#txtNombreCorto").val("");
	$("#txtRfc").val("");
	$("#txtDomicilio").val("");
	$("#txtContacto").val("");
	$("#txtCorreo").val("");
	$("#txtNoExterior").val("");	
	$("#txtNoInterior").val("");
	$("#txtCp").val("");
	$("#txtTelefono").val("");
	$("#txtDescuento").val("");
	$("#txtComision").val("");

	$("#txtEtiquetaBuque").val("");
	$("#txtEtiquetaViaje").val("");

}

function consultarUsoCfdi(){
    $("#ddlUsoCFDI").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catUsoCFDI.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlUsoCFDI").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlUsoCFDI").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function consultarMetodoPago(){
    $("#ddlMetodoPago").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catMetodosPago.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlMetodoPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlMetodoPago").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function consultarFormasPago(){
    $("#ddlFormasPago").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catFormasPago.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlFormasPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlFormasPago").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function consultarCatPaises(){
    $("#ddlPaises").empty();
	  
	var json_request = {
		tipoOperacion: "consultaCatalogoPaises"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlPaises").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlPaises").append('<option value="'+ json.nid +'">'+ json.nombre  +'</option>');
			}		
			
			$("#ddlPaises").val(151);
			$("#txtTrib").val("0");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}


