var $table;
var $tableCorreos;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$table = $('#tablaDatos');
	$tableCorreos  = $('#tablaCorreos');
	
	
	consultarClientes();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	$("#btnRegresar").click(function(){ verClientes(); });
	
	
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				columns: [
					{ "data": "nombrecorto" },
					{ "data": "razonsocial" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vNombreCorto = "'" + oData.nombrecorto + "'";
							$(nTd).html('<span><a href="#" onclick="verCorreos(' + sData +','+ vNombreCorto +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		}
	});
}

function consultarCorreosCliente(pNidCliente, pNombreCliente){
      
	$("#hfNidCliente").val(pNidCliente);  
	$("#spanCliente").text(pNombreCliente);
	  
	var json_request = {
		tipoOperacion: "consultaXestado"  
		,pNidCliente:pNidCliente
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catCorreos.php",
		dataType: "json",
		async: true,
		success: function (resp) {		
		
			console.log(resp);

			$tableCorreos.DataTable().clear().draw();
			$tableCorreos.dataTable().fnDestroy();
			$tableCorreos.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				language: JSON.parse(lenguaje),
				autoWidth: false,
				paging:false,
				columns: [
					{ "data": "correo" },
					{ "data": "tipo" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='cargarCorreos(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
	});
}

function cargarCorreos(pNid){
	
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	var pNidCliente = $("#hfNidCliente").val();
	
	var json_request = {
		tipoOperacion: "consultaXestado"  
		,pNidCliente:pNidCliente
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catCorreos.php",
		dataType: "json",
		async: true,
		success: function (resp) {		
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];	
				
				if(parseInt(json.nid) ===  parseInt(pNid)){					
					$("#txtCorreo").val(json.correo);
					$("#ddlTipoOperacion").val(json.nidTipo);
					
					$("#popupDetalle").modal("show");
				}
			}				
		}
	});
		
}

function verCorreos(pNidCliente, pNombreCliente){
	consultarCorreosCliente(pNidCliente,pNombreCliente);
	$("#divClientes").hide();
	$("#divCorreos").show();
}

function verClientes(){
	$("#divClientes").show();
	$("#divCorreos").hide();
}

function guardar(){
	
	var vNidCliente = $("#hfNidCliente").val();
	var vCuentaCorreo = $("#txtCorreo").val();
	var vTipoCorreo = $("#ddlTipoOperacion").val();
		
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar" 
			,vNidCliente:vNidCliente
            ,vCuentaCorreo:vCuentaCorreo
            ,vTipoCorreo:vTipoCorreo
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catCorreos.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {	
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultarCorreosCliente(vNidCliente,$("#spanCliente").text());
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	var vNid = $("#hfIdSeleccionado").val();
	var vNidCliente = $("#hfNidCliente").val();
	var vCuentaCorreo = $("#txtCorreo").val();
	var vTipoCorreo = $("#ddlTipoOperacion").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,vNid:vNid
			,vNidCliente:vNidCliente
            ,vCuentaCorreo:vCuentaCorreo
            ,vTipoCorreo:vTipoCorreo
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catCorreos.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultarCorreosCliente(vNidCliente,$("#spanCliente").text());
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var vNidCliente = $("#hfNidCliente").val();
	
	var mensaje = "El correo se dar de baja en el sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/catCorreos.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
					   $("#popupDetalle").modal("hide");
						consultarCorreosCliente(vNidCliente,$("#spanCliente").text());
						
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catTarifas.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			$("#txtInicio").val("");
			$("#txtFin").val("");
			$("#txtCosto").val("");	
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vCorreo = $("#txtCorreo").val();
	var vNidTipo = $("#ddlTipoOperacion").val();
	
	if(vCorreo.length === 0){
        $("#txtCorreo").addClass('campo-requerido');
        respuesta=false;
    }
	
	if( parseInt(vNidTipo) < 0){
        $("#ddlTipoOperacion").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtCorreo").val("");
	$("#ddlTipoOperacion").val("-1");
}