var $table;

$("document").ready(function () {
    $("#linkReportes").addClass("subdrop");
	$table = $('#tablaDatos');
	inicialiaValores();
	//consultar();

});


function nuevo(){
	consultarPersonal();	
	$("#popupDetalle").modal("show");	
}

function consultar(){
	
	var pNidPersona = $("#ddlPersonal").val();
	var pFechaInicio = $("#txtFechaInicio").val();
	var pFechaFin = $("#txtFechaFin").val();
      
	var json_request = {
		tipoOperacion: "serviciosPersonal"            
		,pNidPersona:pNidPersona
		,pFechaInicio:pFechaInicio
		,pFechaFin:pFechaFin
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/reportes.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			localStorage.setItem("dtEmpleados", JSON.stringify(resp.datos));
			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				searching:false,
				paging:false,
				buttons: [
					'excel', 'print'
				],			
				columns: [
					{ "data": "nombrePersona" },
					{ "data": "nid",
					    "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span>AMA"+ sData +"</span>");
					    }
					},
					{ "data": "fecha" },
					{ "data": "buque" },
					{ "data": "cliente" },
					{ "data": "tipoServicio" }					
				]
			});		
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("hide");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultarPersonal(){
      $('#ddlPersonal').empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlPersonal").append('<option value="-1">- TODOS -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlPersonal").append('<option value="'+ json.nid +'">'+ json.nombre +' ' + json.paterno + ' ' + json.materno +'</option>');                    
			}			
		}
	});
}

function inicialiaValores(){
	
	
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnConsultar").click(function(){ consultar(); });
	$("#btnExportar").click(function(){ reportePDF(); });
	
		
	//Iniciamos Fechas
	$('input[id$=txtFechaInicio]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
	
		//Iniciamos Fechas
	$('input[id$=txtFechaFin]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
}


function reportePDF(){
	var pHtml = htmlReporte();
	
	var json_request = {
		tipoOperacion: "imprimirReporte",
		pHtml: pHtml
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/reportes.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);	
			$("#iframepdfServicio").attr("src","/moversa/dataAccess/reportePersonal/" + resp.mensaje + ".pdf");
			$("#popupServicio").modal("show");		
		},complete: function () {
			ajaxindicatorstop();
			
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}