
var $tableBuques;
var $tablePersonalProa; //Catalogo personal proa
var $tablePersonalPopa; //Catalogo personal popa

var $datosJson;

var tableProa; //Tabla de personal agregado
var tablePopa; //Tabla de personal agregado

$("document").ready(function () {
	
	$("#linkProgramar").addClass("subdrop");
		
   	//Iniciamos TABS
	$( "#tabs" ).tabs();
   	inicialiaValores();
	
	//consultarNavieras();
	consultarMuelles();
	consultarClientes();
	consultarConceptos();
	
	$("#btnPrimerCabo").click(function(){ primerCabo(); });
	$("#btnPrimerCabo").click(function(){ ventanaPersonal(); });
	$("#btnBuques").click(function(){ ventanaBuquesProgramados(); });
	$("#btnPersonal").click(function(){ consultarPersonal(); });
	$("#btnGuardar").click(function(){ guardar(); });
	
	$("#btnProa").click(function(){ consultarPersonalProa(); });
	$("#btnPopa").click(function(){ consultarPersonalPopa(); });
	
	$("#btnAgregarPersonalProa").click(function(){ agregarPersonalProa(); });
	$("#btnAgregarPersonalPopa").click(function(){ agregarPersonalPopa(); });
	
	$("#btnAtracados").click(function(){ ventanaBuquesAtracados(); });
	
	tableProa = $('#tablaProa').DataTable({
			paging: false,
			searching: true,
			autoWidth: true,
			info:false,
			searching:false,
			language: JSON.parse(lenguaje),
			columnDefs: [{
                targets: [ 0 ],
                visible: false,
                searchable: false
            }]
		});
		
		$('#tablaProa tbody').on('click', 'tr', function () { 
		if ( $(this).hasClass('selected')){ 
			$(this).removeClass('selected'); 
		} else { 
			tableProa.$('tr.selected').removeClass('selected'); 
			$(this).addClass('selected'); } 
		} );
		
		$('#btnProaBorrar').click( function () { 
			tableProa.row('.selected').remove().draw( false ); 
		} ); 
		
		
		tablePopa = $('#tablaPopa').DataTable({
			paging: false,
			searching: true,
			autoWidth: true,
			info:false,
			searching:false,
			language: JSON.parse(lenguaje),
			columnDefs: [{
                targets: [ 0 ],
                visible: false,
                searchable: false
            }]
		});
		
		$('#tablaPopa tbody').on('click', 'tr', function () { 
		if ( $(this).hasClass('selected')){ 
			$(this).removeClass('selected'); 
		} else { 
			tablePopa.$('tr.selected').removeClass('selected'); 
			$(this).addClass('selected'); } 
		} );
		
		$('#btnPopaBorrar').click( function () { 
			tablePopa.row('.selected').remove().draw( false ); 
		} ); 
	
	
});



function inicialiaValores(){	
	
	//Asignamos Tablas a variables
	$table = $("#tablaBuquesProgramados");
	$tablePersonalProa = $("#tablaPersonalProa");
	$tablePersonalPopa = $("#tablaPersonalPopa");
	
	//Iniciamos Fechas
	$('input[id$=txtEta]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: true
    });
	
	
	//Asignamos eventos a los check
	$('#checkBitasA').on('ifChecked', function(event){		
		$('#checkBitasB').iCheck('uncheck');
	});
	
	$('#checkBitasB').on('ifChecked', function(event){		
		$('#checkBitasA').iCheck('uncheck');
	});
	
	
	$('#checkDefensasA').on('ifChecked', function(event){		
		$('#checkDefensasB').iCheck('uncheck');
	});
	
	$('#checkDefensasB').on('ifChecked', function(event){		
		$('#checkDefensasA').iCheck('uncheck');
	});
	
	
	
	$('#checkPinturaA').on('ifChecked', function(event){		
		$('#checkPinturaB').iCheck('uncheck');
	});
	
	$('#checkPinturaB').on('ifChecked', function(event){		
		$('#checkPinturaA').iCheck('uncheck');
	});
	
	
	$('#checkSugercionA').on('ifChecked', function(event){		
		$('#checkSugercionB').iCheck('uncheck');
	});
	
	$('#checkSugercionB').on('ifChecked', function(event){		
		$('#checkSugercionA').iCheck('uncheck');
	});
	
	
	$('#checkParamentoA').on('ifChecked', function(event){		
		$('#checkParamentoB').iCheck('uncheck');
	});
	
	$('#checkParamentoB').on('ifChecked', function(event){		
		$('#checkParamentoA').iCheck('uncheck');
	});
	
}

function ventanaBuquesProgramados(){
	
		$.ajax({
		type: "GET",
		url: "https://www.mediport.com.mx/mediportMovil/Buques.svc/buquesProgramados",
        contentType: "application/json",
        dataType: "json",
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			var listaBuques = resp.d.datos;
			
			datosJson = listaBuques;
			
			    $table.dataTable().fnDestroy();
                $table.DataTable({
                    data: JSON.parse(listaBuques),
					language: JSON.parse(lenguaje),
                    autoWidth: false,
                    columns: [
						{
							
                            "data": "vid",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
								var vImo = oData.imo;
                                $(nTd).html("<span><a href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
                            }
                        },
                        { "data": "buque" },
                        { "data": "eta" },
						{ "data": "naviera" },
						{
                            "data": "vid",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                                var pEstado = "'P'";
                                $(nTd).html('<span><a href="#" onclick="seleccionarBuque(' + sData + ','+ pEstado +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
                            }
                        }
                    ]
                });
			
			$("#popupBuquesProgramados").modal("show");
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (e) {
			ajaxindicatorstop();
			console.log(e.message);
		}
	});
}

function ventanaBuquesAtracados(){
	
		$.ajax({
		type: "GET",
		url: "https://www.mediport.com.mx/mediportMovil/Buques.svc/buquesAtracados",
        contentType: "application/json",
        dataType: "json",
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			var listaBuques = resp.d.datos;
			
			datosJson = listaBuques;
			
			    $table.dataTable().fnDestroy();
                $table.DataTable({
                    data: JSON.parse(listaBuques),
					language: JSON.parse(lenguaje),
                    autoWidth: false,
                    columns: [
						{
							
                            "data": "viaje",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
								var vImo = oData.imo;
                                $(nTd).html("<span><a href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
                            }
                        },
                        { "data": "buque" },
                        { "data": "eta" },
						{ "data": "naviera" },
						{
                            "data": "viaje",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
								var pEstado = "'A'";
                                $(nTd).html('<span><a href="#" onclick="seleccionarBuque(' + sData + ','+ pEstado +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
                            }
                        }
                    ]
                });
			
			$("#popupBuquesProgramados").modal("show");
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (e) {
			ajaxindicatorstop();
			console.log(e.message);
		}
	});

}

function muestraMarineTrafic(pImo) {
	localStorage.setItem("pImoConsultar", pImo);
	location.href = "/moversa/account.php?page=mapa";
}

function seleccionarBuque(pIdViaje, pEstadoBuque){
	
	var listaBuquesJson = JSON.parse(datosJson)
			
	for(var i=0; i < parseInt(listaBuquesJson.length);i++){
		var objBuque = listaBuquesJson[i];
		
		if(pEstadoBuque === 'P'){
			if(parseInt(pIdViaje) === parseInt(objBuque.vid)){			
				$("#txtBuque").val(objBuque.buque);
				$("#txtViaje").val(objBuque.vid);
				$("#txtTrb").val("0");
				$("#txtEslora").val(objBuque.eslora);
				$("#txtEta").val(objBuque.eta);
				$("#txtTrb").val(objBuque.trb);
				$("#hdImo").val(objBuque.imo);	

				$("#ddlNavieras option").filter(function() {
					return this.text == objBuque.naviera; 
				}).attr('selected', true);
				
				$("#ddlClientes option").filter(function() {
					return this.text == objBuque.naviera; 
				}).attr('selected', true);
			}			
		}else{
			if(parseInt(pIdViaje) === parseInt(objBuque.viaje)){			
				$("#txtBuque").val(objBuque.buque);
				$("#txtViaje").val(objBuque.viaje);
				$("#txtTrb").val("0");
				$("#txtEslora").val(objBuque.eslora);
				$("#txtEta").val(objBuque.eta);
				$("#txtTrb").val(objBuque.trb);
				$("#hdImo").val(objBuque.imo);

				$("#ddlNavieras option").filter(function() {
					return this.text == objBuque.naviera; 
				}).attr('selected', true);
				
				$("#ddlClientes option").filter(function() {
					return this.text == objBuque.naviera; 
				}).attr('selected', true);
			}			
		}
		

	}
	
	$("#popupBuquesProgramados").modal("hide");
}

function consultarPersonalProa(){
	$tablePersonalProa.dataTable().fnDestroy();
    $("#tablaPersonalProa tbody").empty();
	
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) { 
	
			//Recorremos el catalogo de personas
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];
				var estaAgregado=0;
				
				//Revisamos si la persona ya esta agregada
				tableProa
					.column( 0 )
					.data()
					.each( function ( value, index ) {
												
						if( parseInt(json.nid) === parseInt(value)){
							estaAgregado = 1;
						}
					} );

				//Revisamos si la persona ya esta agregada en POPA
				tablePopa
					.column( 0 )
					.data()
					.each( function ( value, index ) {
												
						if( parseInt(json.nid) === parseInt(value)){
							estaAgregado = 1;
						}
					} );					

				//Si persona no se a agregado, se da como opcion en catalogo
				if(parseInt(estaAgregado) === 0){
					$tablePersonalProa.append('<tr>' +
					'    <td class="a-center"><input type="checkbox" class="flat" name="table_records"></td>' +
					'    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanNombre">' + json.nombre + " " + json.paterno + " " + json.materno + '</span></td>' +
					'    <td><span id="spanPuesto">' + json.puesto + '</span></td>' +
					'</tr>');
				}
			}
										
			$tablePersonalProa.DataTable({
				paging: false,
				searching: true,
				autoWidth: true,
				info:false,
				language: JSON.parse(lenguaje),
			});

			$.getScript("../moversa/assets/js/icheckTable.js");			
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupPersonalProa").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function consultarPersonalPopa(){
	$tablePersonalPopa.dataTable().fnDestroy();
    $("#tablaPersonalPopa tbody").empty();
	
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) { 
	
			//Recorremos el catalogo de personas
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];
				var estaAgregado=0;
				
				//Revisamos si la persona ya esta agregada en POPA
				tablePopa
					.column( 0 )
					.data()
					.each( function ( value, index ) {
												
						if( parseInt(json.nid) === parseInt(value)){
							estaAgregado = 1;
						}
					} );
					
				//Revisamos si la persona ya esta agregada en PROA
				tableProa
					.column( 0 )
					.data()
					.each( function ( value, index ) {
												
						if( parseInt(json.nid) === parseInt(value)){
							estaAgregado = 1;
						}
					} );	

				//Si persona no se a agregado, se da como opcion en catalogo
				if(parseInt(estaAgregado) === 0){
					$tablePersonalPopa.append('<tr>' +
					'    <td class="a-center"><input type="checkbox" class="flat" name="table_records"></td>' +
					'    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanNombre">' + json.nombre + " " + json.paterno + " " + json.materno + '</span></td>' +
					'    <td><span id="spanPuesto">' + json.puesto + '</span></td>' +
					'</tr>');
				}
			}
										
			$tablePersonalPopa.DataTable({
				paging: false,
				searching: true,
				autoWidth: true,
				info:false,
				language: JSON.parse(lenguaje),
			});

			$.getScript("../moversa/assets/js/icheckTable.js");			
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupPersonalPopa").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

/*function consultarNavieras(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catNavieras.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			$("#ddlNaviera").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlNaviera").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');                    
			}				
		}
	});
}*/

function consultarMuelles(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catMuelles.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlMuelles").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlMuelles").append('<option value="'+ json.nid +'">'+ json.nombre +'</option>');                    
			}				
		}
	});
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlClientes").append('<option value="-1">- Seleccione -</option>'); 
			$("#ddlNavieras").append('<option value="-1">- Seleccione -</option>');
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlClientes").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');
				$("#ddlNavieras").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');
			}				
		}
	});
}

function consultarConceptos(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catConceptos.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			console.log(resp);
			$("#ddlTipoOperacion").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlTipoOperacion").append('<option value="'+ json.nid +'">'+ json.concepto +'</option>');                    
			}				
		}
	});
}

function guardar(){
	var pBuque = $("#txtBuque").val();
	var pViaje = $("#txtViaje").val();
	var pTrb = $("#txtTrb").val();
	var pEslora = $("#txtEslora").val();
	var pNaviera = $("#ddlNavieras").val();
	var pEta = $("#txtEta").val();
	var pMuelle = $("#ddlMuelles").val();
	var pTipoOperacion = $("#ddlTipoOperacion").val();
	var pCliente = $("#ddlClientes").val();
	var pComentarios = $("#txtComentarios").val();
	var pImo = $("#hdImo").val();
	var pViajeNaviera = $("#txtViajeNaviera").val();

	if(validaDatos()){
		if(validaPersonal()){
			var json_request = {
				tipoOperacion: "guardarProgramacion"            
				,pBuque:pBuque
				,pViaje:pViaje
				,pTrb:pTrb
				,pEslora:pEslora
				,pNaviera: pNaviera				
				,pEta: pEta
				,pMuelle: pMuelle
				,pTipoOperacion: pTipoOperacion
				,pCliente: pCliente
				,pComentarios: pComentarios
				,pImo:pImo
				,pSupervisor:1
				,pViajeNaviera:pViajeNaviera
			};
			
			console.log('pBuque ->' + pBuque);
			console.log('pViaje ->' + pViaje);
			console.log('pTrb ->' + pTrb);
			console.log('pEslora ->' + pEslora);
			console.log('pNaviera ->' + pNaviera);
			console.log('pEta ->' + pEta);
			console.log('pMuelle ->' + pMuelle);
			console.log('pTipoOperacion ->' + pTipoOperacion);
			console.log('pCliente ->' + pCliente);
			console.log('pComentarios ->' + pComentarios);
			console.log('pViajeNaviera ->' + pViajeNaviera);
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosProgramar.php",
				dataType: "json",
				async: true,
				beforeSend: function () {
					ajaxindicatorstart();
				},
				success: function (resp) {             
					console.log(resp);
					
					if(parseInt(resp.transaccion) === 0){
						MessageBox(resp.transaccion, resp.mensaje);
					}else{
						var vNidServicio = resp.nid;
					
						console.log("-------------> popa");
						//Guardamos pesonas de POPA
						tablePopa.column( 0 ).data()
							.each( function ( value, index ) {						
								guardarPersonal(vNidServicio, value, "1");
							});
							
						console.log("-------------> proa");
						tableProa.column( 0 ).data()
							.each( function ( value, index ) {
								guardarPersonal(vNidServicio, value, "2");
							});
						}
						
						limpiarCampos();
						MessageBox(resp.transaccion, resp.mensaje);
				},
				complete: function () {
					ajaxindicatorstop();
					//consultar();
				},
				error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);
				}
			});
		}
	}	
}

function guardarPersonal(pNidServicio, pNidPersona, pNidPosicion){
	
	var json_request = {
		tipoOperacion: "guardarPersonal"            
		,pNidServicio:pNidServicio
		,pNidPersona:pNidPersona
		,pNidPosicion:pNidPosicion
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramar.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(pNidPersona +" -> " + OK);
		}
	});	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var pBuque = $("#txtBuque").val();
	var pViaje = $("#txtViaje").val();
	var pTrb = $("#txtTrb").val();
	var pEslora = $("#txtEslora").val();
	var pNaviera = $("#ddlNavieras").val();
	var pEta = $("#txtEta").val();
	var pMuelle = $("#ddlMuelles").val();
	var pTipoOperacion = $("#ddlTipoOperacion").val();
	var pCliente = $("#ddlClientes").val();
	var pComentarios = $("#txtComentarios").val();
	
	if(parseInt(pCliente) === -1 ){
        $("#ddlClientes").addClass('campo-requerido');
        respuesta=false;
    }	
	
	if(parseInt(pTipoOperacion) === -1 ){
        $("#ddlTipoOperacion").addClass('campo-requerido');
        respuesta=false;
    }	

	if(parseInt(pNaviera) === -1 ){
        $("#ddlNavieras").addClass('campo-requerido');
        respuesta=false;
    }	

	if(pEta.length === 0){
        $("#txtEta").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(pMuelle) === -1){
        $("#ddlMuelles").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pBuque.length === 0){
        $("#txtBuque").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pViaje.length === 0){
        $("#txtViaje").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pTrb.length === 0){
        $("#txtTrb").addClass('campo-requerido');
        respuesta=false;
    }

	if(pEslora.length === 0){
        $("#txtEslora").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Faltan datos por llenar del formato, revise bordes color rojo", "error");
    }
    
    return respuesta;
}

function validaPersonal(){
	var respuesta=true;
    var mensaje="";
	

	var totalProa  =tableProa.column( 0 ).data().length
	var totalPopa  =tablePopa.column( 0 ).data().length
	
	if(parseInt(totalProa) === 0){
		respuesta = false;
	}	

	if(parseInt(totalPopa) === 0){
		respuesta = false;
	}		
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta agregar al personal que participará en la maniobra PROA / POPA", "error");
    }
    
    return respuesta;
	
}

function agregarPersonalProa(){

	$("#tablaPersonalProa tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var nid = $(this).find("input[type=hidden]").val();
			var vNombre = $(this).find("#spanNombre").text();
			var vPuesto = $(this).find("#spanPuesto").text();
            
			tableProa.row.add([
				nid
				,vNombre
				,vPuesto
			]).draw(false);
			
        }
    });
	
	$("#popupPersonalProa").modal("hide");
}

function agregarPersonalPopa(){


	$("#tablaPersonalPopa tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var nid = $(this).find("input[type=hidden]").val();
			var vNombre = $(this).find("#spanNombre").text();
			var vPuesto = $(this).find("#spanPuesto").text();
            
			tablePopa.row.add([
				nid
				,vNombre
				,vPuesto
			]).draw(false);
			
        }
    });
	
	$("#popupPersonalPopa").modal("hide");
}

function limpiarCampos(){
	$("#txtBuque").val("");
	$("#txtViaje").val("");
	$("#txtTrb").val("");
	$("#txtEslora").val("");
	$("#txtNaviera").val("");
	$("#txtEta").val("");
	$("#ddlMuelles").val("-1");
	$("#ddlTipoOperacion").val("-1");
	$("#ddlClientes").val("-1");
	$("#ddlNavieras").val("-1");
	$("#txtComentarios").val("");
	
	tablePopa.clear().draw();
	tableProa.clear().draw();
}