var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuClientes").addClass("SubMenuSeleccionado");
	
	$table = $('#tablaDatos');
	
			//Iniciamos Fechas
	$('input[id$=txtFechaCorte]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false,	
		closeOnDateSelect: true	
    });
	
	$('#ddlPaises').on('change', function (e) {

		var vClavePais = $("#ddlPaises").val();

		if(parseInt(vClavePais) === 40 || parseInt(vClavePais) === 66){
			$("#txtTrib").attr("disabled",false);
			$("#txtTrib").val("");
		}else{
			$("#txtTrib").attr("disabled",true);
			$("#txtTrib").val("0");
		}
	});
	
	consultarClientes();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
});


function nuevo(){
    
    	consultarUsoCfdi();
	consultarMetodoPago();
	consultarFormasPago();
	consultarCatPaises();
	
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalleCliente").modal("show");		
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				"pageLength": 25,
				autoWidth: false,
				columns: [
					{ "data": "razonsocial" },
					{ "data": "patente" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
	});
}


function guardar(){
	
	var pNombre = $("#txtNombre").val();
	var pPatente = $("#txtPatente").val();
	var pToken = $("#txtToken").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();	
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	var vFechaCorte = $("#txtFechaCorte").val();
	var vUsoCfdi = $("#ddlUsoCFDI").val();
	var vMetodoPago = $("#ddlMetodoPago").val();
	var vFormaPago = $("#ddlFormasPago").val();
	var vClavePais = $("#ddlPaises").val();
	var vIdTrip = $("#txtTrib").val();
	var vClaveEstado = $("#txtEstado").val();
	var vClaveMunicipio = $("#txtMunicipios").val();
	var vClaveLocalidad = $("#txtLocalidad").val();
	var vClaveColonia = $("#txtColonia").val();
	var vCorreo = $("#txtCorreo").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"            
            ,pNombre:pNombre
            ,pPatente:pPatente
			,pToken:pToken
			,vRfc:vRfc
            ,vDomicilio:vDomicilio
			,vNoExterior: vNoExterior
			,vNoInterior: vNoInterior
			,vCp: vCp
			,vTelefono: vTelefono
			,vFechaCorte:vFechaCorte
			,vUsoCfdi:vUsoCfdi
			,vMetodoPago:vMetodoPago
			,vFormaPago:vFormaPago
			,vClavePais:vClavePais
			,vIdTrip:vIdTrip
			,vClaveEstado:vClaveEstado
			,vClaveMunicipio:vClaveMunicipio
			,vClaveLocalidad:vClaveLocalidad
			,vClaveColonia:vClaveColonia
			,vCorreo:vCorreo
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientes.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultarClientes();
				$("#popupDetalleCliente").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var pNombre = $("#txtNombre").val();
	var pPatente = $("#txtPatente").val();
	var pToken = $("#txtToken").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();	
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	var vFechaCorte = $("#txtFechaCorte").val();
	var vUsoCfdi = $("#ddlUsoCFDI").val();
	var vMetodoPago = $("#ddlMetodoPago").val();
	var vFormaPago = $("#ddlFormasPago").val();
	var vClavePais = $("#ddlPaises").val();
	var vIdTrip = $("#txtTrib").val();
	var vClaveEstado = $("#txtEstado").val();
	var vClaveMunicipio = $("#txtMunicipios").val();
	var vClaveLocalidad = $("#txtLocalidad").val();
	var vClaveColonia = $("#txtColonia").val();
	var vCorreo = $("#txtCorreo").val();
	
    if(validaDatos()){
               
		var json_request = {
            tipoOperacion: "actualizar"
			,pNid:pNid
            ,pNombre:pNombre
			,pPatente:pPatente
			,pToken:pToken
            ,vRfc:vRfc
            ,vDomicilio:vDomicilio
			,vNoExterior: vNoExterior
			,vNoInterior: vNoInterior
			,vCp: vCp
			,vTelefono: vTelefono
			,vFechaCorte:vFechaCorte
			,vUsoCfdi:vUsoCfdi
			,vMetodoPago:vMetodoPago
			,vFormaPago:vFormaPago
			,vClavePais:vClavePais
			,vIdTrip:vIdTrip
			,vClaveEstado:vClaveEstado
			,vClaveMunicipio:vClaveMunicipio
			,vClaveLocalidad:vClaveLocalidad
			,vClaveColonia:vClaveColonia
			,vCorreo:vCorreo
        };
		
		console.log(json_request);
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientes.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultarClientes();
				$("#popupDetalleCliente").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "El anticipo se eliminar";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					 url: "/sippre/dataAccess/catClientes.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultarClientes();
						$("#popupDetalleCliente").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){

	consultarUsoCfdi();
	consultarMetodoPago();
	consultarFormasPago();
	consultarCatPaises();
	
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		 url: "/sippre/dataAccess/catClientes.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
		
			console.log(resp);
			
			console.log(resp.datos[0].fechaCorte);
		
			$("#txtNombre").val(resp.datos[0].nombre);
			$("#txtPatente").val(resp.datos[0].patente);
			$("#txtToken").val(resp.datos[0].token);
			
			$("#txtRfc").val(resp.datos[0].rfc);
			$("#txtDomicilio").val(resp.datos[0].domicilio);	
			$("#txtNoExterior").val(resp.datos[0].exterior);	
			$("#txtNoInterior").val(resp.datos[0].interior);
			$("#txtCp").val(resp.datos[0].cp);
			$("#txtTelefono").val(resp.datos[0].telefono);
			$("#txtFechaCorte").val(resp.datos[0].fechaCorte);
			$("#ddlUsoCFDI").val(resp.datos[0].usoCfdi);
			$("#ddlMetodoPago").val(resp.datos[0].metodoPago);
			$("#ddlFormasPago").val(resp.datos[0].formaPago);
			$("#ddlPaises").val(resp.datos[0].clavePais);
			$("#txtTrib").val(resp.datos[0].idTrip);
			$("#txtEstado").val(resp.datos[0].claveEstado);
			$("#txtMunicipios").val(resp.datos[0].claveMunicipio);
			$("#txtLocalidad").val(resp.datos[0].claveLocalidad);
			$("#txtColonia").val(resp.datos[0].claveColonia);
			$("#txtCorreo").val(resp.datos[0].correo);
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalleCliente").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vNombre = $("#txtNombre").val();
	var vPatente = $("#txtPatente").val();
	var vToken = $("#txtToken").val();
	
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();

	var vFechaCorte = $("#txtFechaCorte").val();
	var vUsoCfdi = $("#ddlUsoCFDI").val();
	var vMetodoPago = $("#ddlMetodoPago").val();
	var vFormaPago = $("#ddlFormasPago").val();

	var vClavePais = $("#ddlPaises").val();
	var vIdTrip = $("#txtTrib").val();
	var vClaveEstado = $("#txtEstado").val();
	var vClaveMunicipio = $("#txtMunicipios").val();
	var vClaveLocalidad = $("#txtLocalidad").val();
	var vClaveColonia = $("#txtColonia").val();
	var vCorreo = $("#txtCorreo").val();
	
	if(vCorreo.length === 0){
         $("#txtCorreo").addClass('campo-requerido');
        respuesta=false;
    }else{
        expr = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        if ( !expr.test(vCorreo) ){
             $("#txtCorreo").addClass('campo-requerido');
            respuesta=false;
        }
    }
	
	if(vNombre.length === 0){
         $("#txtNombre").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vPatente.length === 0){
         $("#txtPatente").addClass('campo-requerido');
        respuesta=false;
    }
		
	if(vToken.length === 0){
         $("#txtToken").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(vClaveEstado.length === 0){
		$("#txtEstado").addClass('campo-requerido');
	   	respuesta=false;
   	}

	if(vClaveMunicipio.length === 0){
		$("#txtMunicipios").addClass('campo-requerido');
	   	respuesta=false;
   	}

	if(vClaveLocalidad.length === 0){
		$("#txtLocalidad").addClass('campo-requerido');
	   	respuesta=false;
   	}

	if(vClaveColonia.length === 0){
		$("#txtColonia").addClass('campo-requerido');
	   	respuesta=false;
   	}


	if(parseInt(vClavePais) === -1){
        $("#ddlPaises").addClass('campo-requerido');
        respuesta=false;
    }else{
		if(vIdTrip.length === 0){
			$("#txtTrib").addClass('campo-requerido');
			   respuesta=false;
		}else{
			if(parseInt(vClavePais) === 40 || parseInt(vClavePais) === 66){
				if(vIdTrip.length != 9){
					$("#txtTrib").addClass('campo-requerido');
					   respuesta=false;
				}
			}
		}
	}

	
	if(vFechaCorte.length === 0){
         $("#txtFechaCorte").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vFormaPago) === -1){
        $("#ddlFormasPago").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vMetodoPago) === -1){
        $("#ddlMetodoPago").addClass('campo-requerido');
        respuesta=false;
    }

	
	if(parseInt(vUsoCfdi) === -1){
        $("#ddlUsoCFDI").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(vDomicilio.length === 0){
         $("#txtDomicilio").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vRfc.length === 0){
         $("#txtRfc").addClass('campo-requerido');
        respuesta=false;
    }
	
	/*if(vTelefono.length === 0){
         $("#txtTelefono").addClass('campo-requerido');
        respuesta=false;
    }*/
	
	if(vCp.length === 0){
         $("#txtCp").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNoExterior.length === 0){
         $("#txtNoExterior").addClass('campo-requerido');
        respuesta=false;
    }
	
	/*if(vNoInterior.length === 0){
         $("#txtNoInterior").addClass('campo-requerido');
        respuesta=false;
    }*/
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
	
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtNombre").val("");
	$("#txtPatente").val("");
	$("#txtToken").val("");
	
	
	$("#txtNombre").val("");
	$("#txtPatente").val("");
	$("#txtToken").val("");
	$("#txtRfc").val("");
	$("#txtDomicilio").val("");	
	$("#txtNoExterior").val("");	
	$("#txtNoInterior").val("");
	$("#txtCp").val("");
	$("#txtTelefono").val("");
	$("#txtFechaCorte").val("");
	$("#ddlUsoCFDI").val("");
	$("#ddlMetodoPago").val("");
	$("#ddlFormasPago").val("");
	$("#ddlPaises").val("");
	$("#txtTrib").val("");
	$("#txtEstado").val("");
	$("#txtMunicipios").val("");
	$("#txtLocalidad").val("");
	$("#txtColonia").val("");
	$("#txtCorreo").val("");
	
}

function consultarUsoCfdi(){
    $("#ddlUsoCFDI").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catUsoCFDI.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlUsoCFDI").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlUsoCFDI").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function consultarMetodoPago(){
    $("#ddlMetodoPago").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catMetodosPago.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlMetodoPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlMetodoPago").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function consultarFormasPago(){
    $("#ddlFormasPago").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catFormasPago.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlFormasPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlFormasPago").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function consultarCatPaises(){
    $("#ddlPaises").empty();
	  
	var json_request = {
		tipoOperacion: "consultaCatalogoPaises"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catClientes.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlPaises").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlPaises").append('<option value="'+ json.nid +'">'+ json.nombre  +'</option>');
			}		
			
			$("#ddlPaises").val(151);
			$("#txtTrib").val("0");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}