var $table;
var $tableDetalle;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuClientesMateriales").addClass("SubMenuSeleccionado");
	
	$table = $('#tablaDatos');
	$tableDetalle = $('#tablaDetalle');
	
	consultarClientes();
		
	$("#btnRegresar").click(function(){ verDivGeneral(); });
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaClientes"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientesMaterial.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				"pageLength": 25,
				autoWidth: false,
				columns: [
					{ "data": "nombre" },
					{ "data": "patente" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pNombre = "'" + oData.nombre + "'";
							$(nTd).html('<span><a href="#" onclick="verDivDetalle(' + sData + ','+ pNombre +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		}
	});
}


function verDivDetalle(pNid,pNombre){
	$("#spanClienteEncabezado").text(pNombre);
	$("#hfIdCliente").val(pNid);	
	
	$("#divGeneral").hide();
	$("#divDetalle").show();
	
	consultaMaterial();
}

function verDivGeneral(pNid){
	$("#divGeneral").show();
	$("#divDetalle").hide();
}


function consultaMaterial(){

	var pNidCliente = $("#hfIdCliente").val();	
	      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientesMaterial.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			$tableDetalle.DataTable().clear().draw();
			$tableDetalle.dataTable().fnDestroy();
			$tableDetalle.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "material" },
					{ "data": "unidad" },
					{ "data": "costo" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vCosto = oData.costo;
							$(nTd).html('<span><a href="#" onclick="verDetalle(' + sData + ','+ vCosto +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function verDetalle(pNid, pNidCosto){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();	
	$("#hfIdSeleccionado").val(pNid);	
	$("#txtCosto").val(pNidCosto);
	$("#popupDetalle").modal("show");
}

function actualizar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var pNidCliente = $("#hfIdCliente").val();	
	var pCosto = $("#txtCosto").val();
		
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,pNid:pNid
			,pNidCliente:pNidCliente
            ,pCosto:pCosto
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientesMaterial.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultaMaterial();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var pNidCliente = $("#hfIdCliente").val();	
	
	var mensaje = "El material ser dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pNidCliente:pNidCliente
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/catClientesMaterial.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultaMaterial();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		
		  }
		});
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vCosto = $("#txtCosto").val();
	
	if(vCosto.length === 0){
         $("#txtCosto").addClass('campo-requerido');
        respuesta=false;
    }	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtCosto").val("");
}