var $table;
var $tableDetalle;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuClientesPersonal").addClass("SubMenuSeleccionado");
	
	$table = $('#tablaDatos');
	$tableDetalle = $('#tablaDetalle');
	
	consultarClientes();
		
	$("#btnRegresar").click(function(){ verDivGeneral(); });
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaClientes"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientesPersonal.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "nombre" },
					{ "data": "patente" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pNombre = "'" + oData.nombre + "'";
							$(nTd).html('<span><a href="#" onclick="verDivDetalle(' + sData + ','+ pNombre +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		}
	});
}


function verDivDetalle(pNid,pNombre){
	$("#spanClienteEncabezado").text(pNombre);
	$("#hfIdCliente").val(pNid);	
	
	$("#divGeneral").hide();
	$("#divDetalle").show();
	
	consultaPersonal();
}

function verDivGeneral(pNid){
	$("#divGeneral").show();
	$("#divDetalle").hide();
}


function consultaPersonal(){
	
	var pNidCliente = $("#hfIdCliente").val();	
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientesPersonal.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			$tableDetalle.DataTable().clear().draw();
			$tableDetalle.dataTable().fnDestroy();
			$tableDetalle.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "nombre" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pNombre = "'" + oData.nombre + "'";
							$(nTd).html('<span><a href="#" onclick="verDetalle(' + sData + ','+ pNombre +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		}
	});
}

function guardar(){
	
	var pNombre = $("#txtNombre").val();
	var pNidCliente = $("#hfIdCliente").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"   
			,pNidCliente:pNidCliente
            ,pNombre:pNombre
        };
		        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientesPersonal.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultaPersonal();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdPersonal").val();
	var pNidCliente = $("#hfIdCliente").val();
	var pNombre = $("#txtNombre").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,pNid:pNid
			,pNidCliente:pNidCliente
            ,pNombre:pNombre
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientesPersonal.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultaPersonal();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdPersonal").val();
	var pNidCliente = $("#hfIdCliente").val();
	
	var mensaje = "La persona será dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pNidCliente:pNidCliente
					,pActivo:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					 url: "/sippre/dataAccess/catClientesPersonal.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultaPersonal();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdPersonal").val(pNid);
	
	var pNidCliente = $("#hfIdCliente").val();
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		 url: "/sippre/dataAccess/catClientesPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			$("#txtNombre").val(resp.datos[0].nombre);
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vNombre = $("#txtNombre").val();
	
	if(vNombre.length === 0){
         $("#txtNombre").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtNombre").val("");
}