var $table;
var $tableDetalle;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuTarifas").addClass("SubMenuSeleccionado");
	
	$table = $('#tablaDatos');
	$tableDetalle = $('#tablaDetalle');
	
	consultarClientes();
		
	$("#btnRegresar").click(function(){ verDivGeneral(); });
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	
	$('#ddlTipoCarga').on('change', function() {
	   configurarTipoCarga(this.value);
	});
	
	$('#ddlTipoServicio').on('change', function() {
	   configurarTipoServicio(this.value);
	});
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");

	$( "#ddlTipoCarga" ).prop( "disabled", false );
	$( "#ddlTipoServicio" ).prop( "disabled", false );
	$( "#ddlImo" ).prop( "disabled", false );
	$( "#ddlTipoPeso" ).prop( "disabled", false );	
}

function consultarClientes(){

	var json_request = {
		tipoOperacion: "consultaClientes"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientesTarifas.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
		
			console.log(resp);
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "nombre" },
					{ "data": "patente" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pNombre = "'" + oData.nombre + "'";
							$(nTd).html('<span><a href="#" onclick="verDivDetalle(' + sData + ','+ pNombre +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		}
	});
}


function verDivDetalle(pNid,pNombre){
	$("#spanClienteEncabezado").text(pNombre);
	$("#hfIdCliente").val(pNid);	
	
	$("#divGeneral").hide();
	$("#divDetalle").show();
	
	consultaTarifas();
}

function verDivGeneral(pNid){
	$("#divGeneral").show();
	$("#divDetalle").hide();
}


function consultaTarifas(){
		
	var pNidCliente = $("#hfIdCliente").val();	
	      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientesTarifas.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			$tableDetalle.DataTable().clear().draw();
			$tableDetalle.dataTable().fnDestroy();
			$tableDetalle.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "tipoCarga" },
					{ "data": "tipoServicio" },
					{ "data": "imo" },
					{ "data": "tipoPeso" },
					{ "data": "costo" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pNombre = "'" + oData.nombre + "'";
							$(nTd).html('<span><a href="#" onclick="verDetalle(' + sData + ','+ pNombre +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});			
		},
		error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
	});
}

function guardar(){
	
	var pNidCliente = $("#hfIdCliente").val();
	var pTipoCarga = $("#ddlTipoCarga").val();
	var pTipoServicio = $("#ddlTipoServicio").val();
	var pTipoImo = $("#ddlImo").val();
	var pTipoPeso = $("#ddlTipoPeso").val();
	var pCosto = $("#txtCosto").val();
	
	//Si tipo carga es "Contenerizada", no aplica "tipo peso"
	if(parseInt(pTipoCarga) === 1){
		pTipoPeso = '-1';
	}
	
	//Si tipo carga es "Suelta", no aplica "IMO"
	if(parseInt(pTipoCarga) === 2){
		pTipoImo = '-1';
	}
	
	console.log('pTipoCarga ->' + pTipoCarga);
	console.log('pTipoServicio ->' + pTipoServicio);
	console.log('pTipoImo ->' + pTipoImo);
	console.log('pTipoPeso ->' + pTipoPeso);
	console.log('pCosto ->' + pCosto);

	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"   
			,pNidCliente:pNidCliente
			,pTipoCarga:pTipoCarga
			,pTipoServicio:pTipoServicio
			,pTipoImo:pTipoImo
			,pTipoPeso:pTipoPeso
            ,pCosto:pCosto
        };
		        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientesTarifas.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultaTarifas();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdPersonal").val();
	var pNidCliente = $("#hfIdCliente").val();
	var pTipoCarga = $("#ddlTipoCarga").val();
	var pTipoServicio = $("#ddlTipoServicio").val();
	var pTipoImo = $("#ddlImo").val();
	var pTipoPeso = $("#ddlTipoPeso").val();
	var pCosto = $("#txtCosto").val();
	
	//Si tipo carga es "Contenerizada", no aplica "tipo peso"
	if(parseInt(pTipoCarga) === 1){
		pTipoPeso = '-1';
	}
	
	//Si tipo carga es "Suelta", no aplica "IMO"
	if(parseInt(pTipoCarga) === 2){
		pTipoImo = '-1';
	}
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,pNid:pNid
			,pNidCliente:pNidCliente
			,pTipoCarga:pTipoCarga
			,pTipoServicio:pTipoServicio
			,pTipoImo:pTipoImo
			,pTipoPeso:pTipoPeso
            ,pCosto:pCosto
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catClientesTarifas.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultaTarifas();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdPersonal").val();
	var pNidCliente = $("#hfIdCliente").val();
	
	var mensaje = "La persona serÃ¡ dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pNidCliente:pNidCliente
					,pActivo:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					 url: "/sippre/dataAccess/catClientesTarifas.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
						ajaxindicatorstop();
						consultaTarifas();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdPersonal").val(pNid);
	
	var pNidCliente = $("#hfIdCliente").val();
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		 url: "/sippre/dataAccess/catClientesTarifas.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	

			//Carga los datos en el comobo tipo servicio
			//cargaTipoServicio(resp.datos[0].nidTipoCarga);
			$("#ddlTipoCarga").val(resp.datos[0].nidTipoCarga);
			$("#ddlTipoServicio").val(resp.datos[0].nidTipoServicio);
			$("#ddlImo").val(resp.datos[0].nidImo);
			$("#txtCosto").val(resp.datos[0].costo);
			
			if(parseInt(resp.datos[0].nidTipoCarga) === 1){
				$("#divPeso").hide();
				$("#divImo").show();
			}else{
				$("#divPeso").show();
				$("#divImo").hide();
				$("#ddlTipoPeso").empty();
				
				if(parseInt(resp.datos[0].nidTipoServicio) === 1){
					$("#ddlTipoPeso").append('<option value="-1">- Seleccione -</option>'); 
					$("#ddlTipoPeso").append('<option value="0">De 0 a 7000</option>'); 
					$("#ddlTipoPeso").append('<option value="1">Cada 100 Kg adicionales</option>');
				}else{
					$("#ddlTipoPeso").append('<option value="0">De 0 a 7000</option>'); 
				}
				
				$("#ddlTipoPeso").val(resp.datos[0].nidTipoPeso);
			}
			
			$( "#ddlTipoCarga" ).prop( "disabled", true );
			$( "#ddlTipoServicio" ).prop( "disabled", true );
			$( "#ddlImo" ).prop( "disabled", true );
			$( "#ddlTipoPeso" ).prop( "disabled", true );

		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var pTipoCarga = $("#ddlTipoCarga").val();
	var pTipoServicio = $("#ddlTipoServicio").val();
	var pTipoImo = $("#ddlImo").val();
	var pCosto = $("#txtCosto").val();
	var pTipoPeso = $("#ddlTipoPeso").val();
	
	if(pTipoCarga.length === 0){
         $("#ddlTipoCarga").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pTipoServicio.length === 0){
         $("#ddlTipoServicio").addClass('campo-requerido');
        respuesta=false;
    }
	

	
	if(pCosto.length === 0){
         $("#txtCosto").addClass('campo-requerido');
        respuesta=false;
    }
	
	//Si tipo carga es "Contenerizada", no aplica "tipo peso"
	if(parseInt(pTipoCarga) === 1){
		if(parseInt(pTipoImo) < 0 ){
			$("#ddlImo").addClass('campo-requerido');
			respuesta=false;
		}
	}
	
	//Si tipo carga es "Suelta", no aplica "IMO"
	if(parseInt(pTipoCarga) === 2){
		if(parseInt(pTipoPeso) < 0){
			$("#ddlTipoPeso").addClass('campo-requerido');
			respuesta=false;
		}
	}
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtNombre").val("");
	$("#ddlTipoCarga").val("-1");
	$("#ddlTipoServicio").val("-1");
	$("#ddlImo").val("-1");
	$("#txtCosto").val("0.0");
}


function configurarTipoCarga(pTipoCarga){
	
	if(parseInt(pTipoCarga) === 1){
		$("#divPeso").hide();
		$("#divImo").show();
	}else{		
		$("#divPeso").show();
		$("#divImo").hide();
	}	
}

function configurarTipoServicio(pTipoServicio){	
	
	var vTipoServicio = $("#ddlTipoCarga").val();
	
	if(parseInt(vTipoServicio) === 1){
		$("#ddlImo").empty();
		
		if(parseInt(pTipoServicio) === 1){
			$("#ddlImo").append('<option value="-1">- Seleccione -</option>'); 
			$("#ddlImo").append('<option value="0">No</option>'); 
			$("#ddlImo").append('<option value="1">Si</option>');
		}else{
			$("#ddlImo").append('<option value="0">No</option>'); 
		}		
	}else{
		
		$("#ddlTipoPeso").empty();
		
		if(parseInt(pTipoServicio) === 1){
			$("#ddlTipoPeso").append('<option value="-1">- Seleccione -</option>'); 
			$("#ddlTipoPeso").append('<option value="0">De 0 a 7000</option>'); 
			$("#ddlTipoPeso").append('<option value="1">Cada 100 Kg adicionales</option>');
		}else{
			$("#ddlTipoPeso").append('<option value="0">De 0 a 7000</option>'); 
		}
	}
	
	
}