var $tablaClientes;
var $tablaMateriales;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuMateriales").addClass("SubMenuSeleccionado");	
	
	$tablaClientes = $('#tablaClientes');
	$tablaMateriales = $('#tablaMateriales');
	
	consultarMateriales();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	$("#btnRegresar").click(function(){ verDivGeneral(); });
});



function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	consultarUNM();
	limpiarCampos();
	consultarClavesSAT();
	$("#popupDetalle").modal("show");		
}

function consultarMateriales(){
	
    
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catMateriales.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
		
			$tablaMateriales.DataTable().clear().draw();
			$tablaMateriales.dataTable().fnDestroy();
			$tablaMateriales.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "nombre" },
					{ "data": "UNM" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
		,
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
	});
}


function guardar(){
	
	var pNombre = $("#txtNombre").val();
	var pNidUNM = $("#ddlUNM").val();
	var pNidClaveSat = $("#ddlClaveSat").val();

    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"            
            ,pNombre:pNombre
			,pNidUNM:pNidUNM
			,pNidClaveSat:pNidClaveSat
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catMateriales.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultarMateriales();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var pNombre = $("#txtNombre").val();
	var pNidUNM = $("#ddlUNM").val();
	var pNidClaveSat = $("#ddlClaveSat").val();
		
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,pNid:pNid
            ,pNombre:pNombre
			,pNidUNM:pNidUNM
			,pNidClaveSat:pNidClaveSat
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catMateriales.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultarMateriales();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "El material serĂ¡ dada de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/catMateriales.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {   
					    console.log(resp);
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultarMateriales();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	consultarUNM();
	consultarClavesSAT();
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catMateriales.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
		console.log(resp);
			$("#txtNombre").val(resp.datos[0].nombre);
			$("#ddlUNM").val(resp.datos[0].nidUNM);
			$("#ddlClaveSat").val(resp.datos[0].nidClaveSat);
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vNombre = $("#txtNombre").val();		
	var pNidUNM = $("#ddlUNM").val();
	
	if(vNombre.length === 0){
         $("#txtNombre").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(pNidUNM) < 0){
         $("#ddlUNM").addClass('campo-requerido');
        respuesta=false;
    }
		
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtNombre").val("");
	$("#ddlUNM").val("-1");
}

function consultarUNM(){
    $("#ddlUNM").empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catUNM.php",
		dataType: "json",
		async: false,
		success: function (resp) {			
		
			console.log(resp);
			$("#ddlUNM").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlUNM").append('<option value="'+ json.nid +'">'+ json.nombre +'</option>');                    
			}	
		}
	});
}

function consultarClavesSAT(){
    $("#ddlClaveSat").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catClavesSAT.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			$("#ddlClaveSat").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlClaveSat").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}