var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuMoversaPersonal").addClass("SubMenuSeleccionado");
	
	$table = $('#tablaDatos');
	
	consultar();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultar(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catMoversaPersonal.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				language: JSON.parse(lenguaje),
				autoWidth: false,
				"pageLength": 25,
				columns: [
					{ "data": "nombre" },
					{ "data": "credencial" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
	});
}


function guardar(){
	
	var pNombre = $("#txtNombre").val();
	var pCredencial = $("#txtCredencial").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"            
            ,pNombre:pNombre
			,pCredencial:pCredencial
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catMoversaPersonal.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var pNombre = $("#txtNombre").val();
	var pCredencial = $("#txtCredencial").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,pNid:pNid
            ,pNombre:pNombre
			,pCredencial:pCredencial
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catMoversaPersonal.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultar();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "La persona será dada de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/catMoversaPersonal.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultar();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catMoversaPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			$("#txtNombre").val(resp.datos[0].nombre);
			$("#txtCredencial").val(resp.datos[0].credencial);
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vNombre = $("#txtNombre").val();
	var vCredencial = $("#txtCredencial").val();
	
	if(vNombre.length === 0){
         $("#txtNombre").addClass('campo-requerido');
        respuesta=false;
    }

	if(vCredencial.length === 0){
         $("#txtCredencial").addClass('campo-requerido');
        respuesta=false;
    }

	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtNombre").val("");
	$("#txtCredencial").val("");
}