var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$table = $('#tablaDatos');
	
	consultar();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
});


function nuevo(){
	
	$("#txtClave").val("");
	$("#txtDescripcion").val("");
			
			
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultar(){
      
	var json_request = {
		tipoOperacion: "consultaXestado" 
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catUsoCFDI.php",
		dataType: "json",
		async: true,
		success: function (resp) {			

			$table.DataTable().clear().draw();			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				columns: [	{ "data": "clave" },
							{ "data": "descripcion" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		},
		    error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
	});
}


function guardar(){
	
	var vClave = $("#txtClave").val();
	var vDescripcion = $("#txtDescripcion").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"  
            ,vClave:vClave
			,vDescripcion:vDescripcion
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../sippre/dataAccess/catUsoCFDI.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var vNid = $("#hfIdSeleccionado").val();
	var vClave = $("#txtClave").val();
	var vDescripcion = $("#txtDescripcion").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,vNid:vNid
            ,vClave:vClave
			,vDescripcion:vDescripcion
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../sippre/dataAccess/catUsoCFDI.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "El uso CFDI será dada de baja del sistema";	
	   swal({
		  title: "Esta seguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../sippre/dataAccess/catUsoCFDI.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultar();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/catUsoCFDI.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			console.log(resp);
		
			$("#txtClave").val(resp.datos[0].clave);
			$("#txtDescripcion").val(resp.datos[0].descripcion);
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vClave = $("#txtClave").val();
	var vDescripcion = $("#txtDescripcion").val();
	
	if(vClave.length === 0){
         $("#txtClave").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vDescripcion.length === 0){
         $("#txtDescripcion").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtClave").val("");
	$("#txtDescripcion").val("");
}