var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$("#listaCatalogos").css("display", "block");
	$("#subMenuCatUsuarios").addClass("SubMenuSeleccionado");
	
	$table = $('#tablaUsuarios');
	
	consultar();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	
	$('#ddlRol').on('change', function() {
	   revisaRolSeleccionado(this.value);
	});
	
	$.getScript("../sippre/assets/plugins/iCheck/icheck.js");
});


function nuevo(){
    
    limpiarCampos();
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	consultarClientes();
	
	$("#modal_add_user").modal("show");	
}

function consultar(){
      
	var json_request = {
		tipoOperacion: "consultaUsuarios"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catUsuarios.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);
			    $table.dataTable().fnDestroy();
                $table.DataTable({
                    data: resp.datos,
                    dom: 'Bfrtip',
                    buttons: [{ extend: 'copy', text: 'Copiar' },
                    { extend: 'csv', text: 'Excel' },
                    { extend: 'print', text: 'Imprimir' }
                    ],
                    "language": JSON.parse(lenguaje),
                    "autoWidth": false,
                    "pageLength": 25,
                    columns: [
                        { "data": "nombre" },
                        { "data": "paterno" },
                        { "data": "materno" },
                        {
                            "data": "nid",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                                $(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
                            }
                        }
                    ]
                });							
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function guardar(){
	
	var vNombre = $("#txtNombre").val();
	var vPaterno = $("#txtPaterno").val();
	var vMaterno = $("#txtMaterno").val();
	var vCorreo = $("#txtCorreo").val();
	var vUsuario = $("#txtUsuario").val();
	var vContrasenia = $("#txtContrasenia").val();
	
	var vRol = $("#ddlRol").val();
	var vNidCliente = $("#ddlCliente").val();
	
	var pNotiApertura;
	var pNotiDesconsolidacion;
	var pNotiRevision;
	var pNotiConsolidacion;
	var pNotiCierre;
	
	if ($('#chekApertura').is(":checked")) { pNotiApertura = 1; }else{ pNotiApertura = 0;}
	if ($('#chekDesconsolidacion').is(":checked")) { pNotiDesconsolidacion = 1; }else{ pNotiDesconsolidacion = 0;}
	if ($('#chekRevision').is(":checked")) { pNotiRevision = 1; }else{ pNotiRevision = 0;}
	if ($('#chekConsolidacion').is(":checked")) { pNotiConsolidacion = 1; }else{ pNotiConsolidacion = 0;}
	if ($('#chekCierre').is(":checked")) { pNotiCierre = 1; }else{ pNotiCierre = 0;}
	
		
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardarUsuario"            
            ,pNombre:vNombre
            ,pPaterno:vPaterno
            ,pMaterno:vMaterno
            ,pUsuario:vUsuario
            ,pContrasenia: vContrasenia
            ,pCorreo:vCorreo
			,pRol:vRol
			,pNidCliente:vNidCliente
			,pNotiApertura:pNotiApertura
			,pNotiDesconsolidacion:pNotiDesconsolidacion
			,pNotiRevision:pNotiRevision
			,pNotiConsolidacion:pNotiConsolidacion
			,pNotiCierre:pNotiCierre
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catUsuarios.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#modal_add_user").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				MessageBox(0, thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var vNombre = $("#txtNombre").val();
	var vPaterno = $("#txtPaterno").val();
	var vMaterno = $("#txtMaterno").val();
	var pCorreo = $("#txtCorreo").val();
	var vUsuario = $("#txtUsuario").val();
	var vContrasenia = $("#txtContrasenia").val();
	
	var vRol = $("#ddlRol").val();
	var vNidCliente = $("#ddlCliente").val();
	
	var pNotiApertura;
	var pNotiDesconsolidacion;
	var pNotiRevision;
	var pNotiConsolidacion;
	var pNotiCierre;
	
	if ($('#chekApertura').is(":checked")) { pNotiApertura = 1; }else{ pNotiApertura = 0;}
	if ($('#chekDesconsolidacion').is(":checked")) { pNotiDesconsolidacion = 1; }else{ pNotiDesconsolidacion = 0;}
	if ($('#chekRevision').is(":checked")) { pNotiRevision = 1; }else{ pNotiRevision = 0;}
	if ($('#chekConsolidacion').is(":checked")) { pNotiConsolidacion = 1; }else{ pNotiConsolidacion = 0;}
	if ($('#chekCierre').is(":checked")) { pNotiCierre = 1; }else{ pNotiCierre = 0;}
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizarUsuario"
			,pNid:pNid
            ,pNombre:vNombre
            ,pPaterno:vPaterno
            ,pMaterno:vMaterno
            ,pUsuario:vUsuario
            ,pContrasenia: vContrasenia
			,pCorreo:pCorreo
			,pRol:vRol
			,pNidCliente:vNidCliente
			,pNotiApertura:pNotiApertura
			,pNotiDesconsolidacion:pNotiDesconsolidacion
			,pNotiRevision:pNotiRevision
			,pNotiConsolidacion:pNotiConsolidacion
			,pNotiCierre:pNotiCierre
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "/sippre/dataAccess/catUsuarios.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#modal_add_user").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
			    console.log(ajaxOptions);
			    console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "El usurio será dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminarUsuario"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/catUsuarios.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
						ajaxindicatorstop();
						consultar();
						$("#modal_add_user").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	consultarClientes();
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaUsuariosXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catUsuarios.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp.datos);	
			$("#txtNombre").val(resp.datos[0].nombre);
			$("#txtPaterno").val(resp.datos[0].paterno);
			$("#txtMaterno").val(resp.datos[0].materno);			
			$("#txtUsuario").val(resp.datos[0].usuario);
			$("#txtContrasenia").val(resp.datos[0].contrasenia);
			$("#txtCorreo").val(resp.datos[0].correo);
			
			$("#ddlRol").val(resp.datos[0].rol);
			
			if(parseInt(resp.datos[0].rol) === 1){
				$("#ddlCliente").val(resp.datos[0].nidCliente);
				$("#divCliente").show();
			}
			
			if(parseInt(resp.datos[0].notiApertura) === 1){ $("#chekApertura").prop("checked", true); } else {$("#chekApertura").prop("checked", false); }
			if(parseInt(resp.datos[0].notiDesconsolidacion) === 1){ $("#chekDesconsolidacion").prop("checked", true); } else {$("#chekDesconsolidacion").prop("checked", false); }
			if(parseInt(resp.datos[0].notiRevision) === 1){ $("#chekRevision").prop("checked", true); } else {$("#chekRevision").prop("checked", false); }
			if(parseInt(resp.datos[0].notiConsolidacion) === 1){ $("#chekConsolidacion").prop("checked", true); } else {$("#chekConsolidacion").prop("checked", false); }
			if(parseInt(resp.datos[0].notiCierre) === 1){ $("#chekCierre").prop("checked", true); } else {$("#chekCierre").prop("checked", false); }

		//if ($('#chekApertura').is(":checked")) { pNotiApertura = 1; }else{ pNotiApertura = 0;}
		//if ($('#chekDesconsolidacion').is(":checked")) { pNotiDesconsolidacion = 1; }else{ pNotiDesconsolidacion = 0;}
		//if ($('#chekRevision').is(":checked")) { pNotiRevision = 1; }else{ pNotiRevision = 0;}
		//if ($('#chekConsolidacion').is(":checked")) { pNotiConsolidacion = 1; }else{ pNotiConsolidacion = 0;}
		//if ($('#chekCierre').is(":checked")) { pNotiCierre = 1; }else{ pNotiCierre = 0;}			
			
		},
		complete: function () {
			ajaxindicatorstop();
			$("#modal_add_user").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vNombre = $("#txtNombre").val();
	var vPaterno = $("#txtPaterno").val();
	var vMaterno = $("#txtMaterno").val();
	var vRol =$("#ddlRol").val();
	var vCorreo = $("#txtCorreo").val();
	var vUsuario = $("#txtUsuario").val();
	var vContrasenia = $("#txtContrasenia").val();
	var vRol = $("#ddlRol").val();
	var vCliente = $("#ddlCliente").val();
	
	if(vNombre.length === 0){
         $("#txtNombre").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vPaterno.length === 0){
        $("#txtPaterno").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vMaterno.length === 0){
         $("#txtMaterno").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(vUsuario.length === 0){
        $("#txtUsuario").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vContrasenia.length === 0){
        $("#txtContrasenia").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(vRol) < 0 ){
		$("#ddlRol").addClass('campo-requerido');
        respuesta=false;
	}else{
	    
	    if(parseInt(vRol) === 1){
	     	if(parseInt(vCliente) < 0 ){
			    $("#ddlCliente").addClass('campo-requerido');
			    respuesta=false;
    		}   
	    }
	}
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlCliente").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlCliente").append('<option value="'+ json.nid +'">'+ json.nombre +'</option>');                    
			}				
		}
	});
}

function revisaRolSeleccionado(pValor){
	if(parseInt(pValor) === 1){
		$("#divCliente").show();
	}else{
		$("#divCliente").hide();
	}
}

function limpiarCampos(){
	$("#txtNombre").val("");
	$("#txtPaterno").val("");
	$("#txtMaterno").val("");
	$("#txtCorreo").val("");
	$("#txtUsuario").val("");
	$("#txtContrasenia").val("");	
	$("#ddlRol").val("-1");
	$("#ddlCliente").val("-1");
	
	$("#chekApertura").prop("checked", false);
	$("#chekDesconsolidacion").prop("checked", false);
	$("#chekRevision").prop("checked", false);
	$("#chekConsolidacion").prop("checked", false);
	$("#chekCierre").prop("checked", false);
}