////////////////////////////////////// 26/10/19 ============================

//Globales
var optTipoServicio = "";
var optCantidadRetirar = "";
var optPersonalEmpresa = "";
var optVistasFiscales = "";
var optDanosContenedor = "";
var panelRelMatUsados = "";

//MAIN
$( document ).ready(function() {
	localStorage.clear();

	//DEBUG SESSION
	//obtenerDatosUsuario();

	//llenar catalogos estaticos
	obtenerTiposServicio();
	obtenerCantidadRetirar();
	obtenerPersonalEmpresa();
	obtenerVistasFiscales();
	obtenerTipoDanosContenedor();
	//obtenerMaterialesServicio();
	obtenerServiciosProgramados();

	eventos();
	$("#linkProgramados").addClass("subdrop");
	//$(".button-menu-mobile").trigger("click");
});

function eventos(){
	
	//rotacion del boton que oculta o muestra la tabla con listado de servicios programados.
	 $("#btnHideServicios").on("click", function(e){
		 $("#btnHideServicios").toggleClass("rotar_elemento_180");
	 });
	
}

function agregarColumnaMaterialUsado(nombre_tabla, codigo_trazabilidad, opciones) { 
    var $filas = $(nombre_tabla).find('tbody tr');
    if ($filas.length==0) {
        var $row = $(nombre_tabla).find('thead tr');
        var $cols = $row.find('th');
        var htmlDat = '';
        $cols.each(function(index, value) {
            if ($(this).attr('name')=='buttons') {
                htmlDat = htmlDat + colEdicHtml;
            } else {
				if (index == 0) {
					htmlDat = htmlDat + "<select class='select form-control " + codigo_trazabilidad + "_selectTipoMaterial'>" + localStorage.getItem(codigo_trazabilidad + "_optMaterialUsado") +"</select></td>";
				} else {
					htmlDat = htmlDat + '<td></td>';
				}
            }
        });
		$(nombre_tabla).find('tbody').append('<tr>'+htmlDat+'</tr>');
		console.log("append a la tabl de material usado")
    } else {
		var htmlDat = "<tr><td><select class='select form-control " + codigo_trazabilidad + "_selectTipoMaterial'>" + localStorage.getItem(codigo_trazabilidad + "_optMaterialUsado") + "</select></td><td contenteditable='true'></td><td contenteditable='true' </td><td>" + newColHtml + "</td></tr>";
		$(nombre_tabla).find('tbody').append(htmlDat);
    }
}

//CATALOGOS
function obtenerTiposServicio(){
	var datos = {
		pTipoOperacion: "obtenerTiposServicio"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de tipos de servicio
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].nomtiposervicio + " </option>";
				}
				optTipoServicio = strtmp;

			} else {
				console.log(resp);
				strtmp = "<option value='-1' selected> No se encontró información </option>";
				optTipoServicio = strtmp;
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});

}

function obtenerCantidadRetirar(){
	var datos = {
		pTipoOperacion: "obtenerCantidadRetirar"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de tipos de servicio
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].medida + " </option>";
				}
				optCantidadRetirar = strtmp;

			} else {
				console.log(resp);
				strtmp = "<option value='-1' selected> No se encontró información </option>";
				optCantidadRetirar = strtmp;
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});

}

function obtenerPersonalEmpresa(){
	var datos = {
		pTipoOperacion: "obtenerPersonalEmpresa"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de tipos de servicio
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].credencial + " - " + resp.datos[i].nombreempleado + " </option>";
				}
				optPersonalEmpresa = strtmp;

			} else {
				console.log(resp);
				strtmp = "<option value='-1' selected> No se encontró información </option>";
				optPersonalEmpresa = strtmp;
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function obtenerVistasFiscales(){
	var datos = {
		pTipoOperacion: "obtenerVistasFiscales"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de tipos de servicio
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].nombre + " </option>";
				}
				optVistasFiscales = strtmp;

			} else {
				console.log(resp);
				strtmp = "<option value='-1' selected> No se encontró información </option>";
				optVistasFiscales = strtmp;
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function obtenerTipoDanosContenedor(){
	var datos = {
		pTipoOperacion: "obtenerTipoDanosContenedor"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de tipos de servicio
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].nomdano + " </option>";
				}
				optDanosContenedor = strtmp;

			} else {
				console.log(resp);
				strtmp = "<option value='-1' selected> No se encontró información </option>";
				optDanosContenedor = strtmp;
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function obtenerMaterialesServicio(cliente, codigo){
    console.log("Obteniendo materiales del servicio " + codigo + " del cliente " + cliente);
	var datos = {
		pTipoOperacion: "obtenerMaterialesServicio",
		pIdCliente: cliente
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de tipos de servicio
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].nombrematerial + " (" + resp.datos[i].descunidad + ")" + " </option>";
				}
				//optMaterialUsado = strtmp;
				localStorage.setItem(codigo + "_optMaterialUsado", strtmp);

			} else {
				console.log(resp);
				strtmp = "<option value='-1' selected> No se encontró información </option>";
				localStorage.setItem(codigo + "_optMaterialUsado", strtmp);
			}
			//panelRelMatUsados = '<div class="row" id="' + codigo + '_relMatUsados" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h3 style="color: green; font-weight: bold;">Consolidación</h3></div><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h4>Cliente a facturar (Importador):</h4><textarea style=" width: 100%; font-size: 14pt; font-weight: bold; color: green; padding: 1%;" rows="2" id="' + codigo + '_txtClienteFacturar" class="form-control"/></textarea></div><div class="col-xs-12 col-sm-12 col-md-8 col-lg-8" style="padding-top: 10px;"><h4>Relación de materiales usados</h4><div id="' + codigo + '_tablaMaterialesUsados" style="background-color: white; text-align: center; "><table class="table"><thead><tr style="background-color: #528933; font-weight: bold; color: white;"><th>Material</th><th>Cantidad</th><th></th></tr></thead><tbody><tr><td><select class="select form-control ' + codigo + '_selectTipoMaterial">' + strtmp + '</select></td><td contenteditable="true">0</td><td contenteditable="false"> </td></tr></tbody></table></div></div><div class="col-xs-12 col-sm-12 col-md-4 col-lg-4" style="padding-top: 10px; padding-left: 0px;"><div class="col-xs-1 col-sm-1 col-md-1 col-lg-1" style="vertical-alignment: center;"><br/><br/><button class="btn btn-success text-center" id="' + codigo + '_btnAgregarMaterial" style="background-color: #528933; border-color: #528933;"><i class="fa fa-plus" style="color: white"/></button></div></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 20px;"><button id="' + codigo + '_btnCierreContenedor" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-window-close"/><br/> CIERRE DE CONTENEDOR </button></div></div>';
			
			panelRelMatUsados = '<div class="row" id="' + codigo + '_relMatUsados" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h3 style="color: green; font-weight: bold;">Consolidación</h3></div><div style="display:none" class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h4>Cliente a facturar (Importador):</h4><textarea style=" width: 100%; font-size: 14pt; font-weight: bold; color: green; padding: 1%;" rows="2" id="' + codigo + '_txtClienteFacturar" class="form-control" value="NO APLICA">DEMO DE TEXTO</textarea></div><div class="col-xs-12 col-sm-12 col-md-8 col-lg-8" style="padding-top: 10px;"><h4>Relación de materiales usados</h4><div id="' + codigo + '_tablaMaterialesUsados" style="background-color: white; text-align: center; "><table class="table"><thead><tr style="background-color: #528933; font-weight: bold; color: white;"><th>Material</th><th>Cantidad</th><th></th></tr></thead><tbody><tr><td><select class="select form-control ' + codigo + '_selectTipoMaterial">' + strtmp + '</select></td><td contenteditable="true">0</td><td contenteditable="false"> </td></tr></tbody></table></div></div><div class="col-xs-12 col-sm-12 col-md-4 col-lg-4" style="padding-top: 10px; padding-left: 0px;"><div class="col-xs-1 col-sm-1 col-md-1 col-lg-1" style="vertical-alignment: center;"><br/><br/><button class="btn btn-success text-center" id="' + codigo + '_btnAgregarMaterial" style="background-color: #528933; border-color: #528933;"><i class="fa fa-plus" style="color: white"/></button></div></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 20px;"><button id="' + codigo + '_btnCierreContenedor" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-window-close"/><br/> CIERRE DE CONTENEDOR </button></div></div>';
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

//CONSULTA INFORMACIÓN DEL SERVICIO
function obtenerServiciosProgramados(){
	var datos = {
		pTipoOperacion: "obtenerServiciosProgramados"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			console.log(resp);
			if (resp.transaccion != null && Number(resp.transaccion > 0)){
				var strtmp = "";
				console.log(resp);
				if(resp.datos != null){
				    for (var x= 0; x < resp.datos.length; x++){
					    var aliascont = (Number(resp.datos[x].idtipocarga) == 2) ? "NA" : resp.datos[x].nomdimension ;
					        strtmp+= 	"<tr class='filaServicioProgramado'>" +
								"<td style='style='text-align: center;'>" + "<button class='btn btn-success addServicioProgramado' style='background-color: green; border-color: green;'><i class='fa fa-plus'></i></button>" + "</td>" +
								"<td style='display: none;'>" + resp.datos[x].idservicio + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idempresa + "</td>" + 
								"<td> MOV" + resp.datos[x].codigotrazabilidad + "</td>" + 
								"<td>" + resp.datos[x].importador + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idcliente + "</td>" + 
								"<td>" + resp.datos[x].nomcliente + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idclipersonal + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idtipocarga + "</td>" + 
								"<td>" + resp.datos[x].nomtipocarga + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].imo + "</td>" + 
								"<td>" + resp.datos[x].descimo + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].iddimcon + "</td>" + 
								//"<td>" + resp.datos[x].nomdimension + "</td>" + 
								"<td>" + aliascont + "</td>" +
								"<td>" + resp.datos[x].contenedor + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].sellooriginal + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].sellonuevo + "</td>" + 
								"<td>" + resp.datos[x].cantidad + "</td>" + 
								"<td>" + resp.datos[x].peso + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idtiposervicio + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].nomtiposervicio + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].iddesmed + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].nomdesmedida + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].notascantidad + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].utilizacanino + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].usacanino + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].notascarga + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].revisionnointrusiva + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].usarevintrusiva + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].muestreomercancia + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].usamuestreo + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].observacionesmuestreo + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].clientefacturar + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].montomaterial + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].montototal + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].fechacaptura + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idusuario + "</td>" + 
								"<td style='display: none;'>" + resp.datos[x].idestado + "</td>" + 
								"<td>" + resp.datos[x].descestado + "</td>" + 
								"</tr>";
				}
			}
				$("#tbodyServiciosProgramados").empty();
				$("#tbodyServiciosProgramados").append(strtmp);

			} else {
				swal("Error","No se pudieron obtener los servicios programados");
			}
			
			//EVENTO
			//Agregar servicio a pestaña.
			$(".addServicioProgramado").on("click", function(e){
				var existe = localStorage.getItem($(this).closest("tr").find("td:nth-child(2)").text()+"_codigo_trazabilidad");
				
				if (existe == null || existe == ''){
					//no existe, lo creamos
					var fila = $(this).closest("tr"); 
					var tipo = Number(fila.find("td:nth-child(9)").text());
					var codigo_trazabilidad = fila.find("td:nth-child(2)").text(); //idServicio
					var rastreabilidad = fila.find("td:nth-child(4)").text(); //codigo de trazabilidad capturado al programar
					var contenedor = fila.find("td:nth-child(15)").text();
					var importador = fila.find("td:nth-child(5)").text();
					var cliente = Number(fila.find("td:nth-child(6)").text());
					var imo = fila.find("td:nth-child(11)").text();
					var status_servicio = fila.find("td:nth-child(38)").text();
					
					
					localStorage.setItem(codigo_trazabilidad+"_cliente", cliente);
					localStorage.setItem(codigo_trazabilidad+"_codigo_trazabilidad", codigo_trazabilidad);
					localStorage.setItem(codigo_trazabilidad+"_tipo", tipo);
					localStorage.setItem(codigo_trazabilidad+"_contenedor", contenedor);
					localStorage.setItem(codigo_trazabilidad+"_importador", importador);
					localStorage.setItem(codigo_trazabilidad+"_imo", imo);
					localStorage.setItem(codigo_trazabilidad+"_status_servicio", status_servicio);
					localStorage.setItem(codigo_trazabilidad + "_EIROK", "0");
					
					//obtenemos los materiales
					obtenerMaterialesServicio(cliente, codigo_trazabilidad);
					
					//tab y panel contenedor
					$("#listadoTabsServicios").append('<li class="nav-item" style="background-color: white; color: black; font-weight: bold;" id="tabDetalle_' + codigo_trazabilidad + '"><a class="nav-link" data-toggle="tab" href="#panelDetalle_' + codigo_trazabilidad + '">' + rastreabilidad + '</a></li>');
					$("#panelesDetalleServicio").append('<div style="width: 100%; min-height: 100vh; background-color: white;" class="tab-pane" id="panelDetalle_' + codigo_trazabilidad + '"></div>');
					
					var panelApertura = '<div style="width: 100%; padding: 10%; display: none;" id="' + codigo_trazabilidad + '_panelApertura"><h3 style="color: green; font-weight: bold;">Apertura</h3><br/><div class="row" style="width: 100%; height: 100%; min-height: 100%;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center" style="width: 100%; padding: 15%;"><button id="' + codigo_trazabilidad + '_btnAperturaServicio" class="btn btn-warning btn-2x text-center">INICIO DEL SERVICIO <br/><i class="fa fa-play fa-2x"/></button></div></div></div>';
					//var panelSelloEyR = '<div class="row" id="' + codigo_trazabilidad + '_panelSelloEyR" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><br/><h3 style="font-weight: bold; color: green;" >Apertura</h3><br/><h5>Sello actual del contenedor: ' + contenedor + '</h5><input id="' + codigo_trazabilidad + '_txtSelloActual" type="text" class="form-control" style="font-weight: bold; font-size: 18pt; color: green;" maxlength="15"/></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><button id="' + codigo_trazabilidad + '_btnEyR" class="btn btn-success text-center" style="width: 100%; height: 100%; background-color: green; border-color: green; font-weight: bold;" data-toggle="modal" data-target="#' + codigo_trazabilidad + '_modalEyR"><i class="fa fa-truck"/><br/> EIR </button></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 5%;"><button id="' + codigo_trazabilidad + '_btnSeleccionarTipoServicio" class="btn btn-lg btn-2x btn-warning text-center"><i class="fa fa-tasks"/> <br/> 	SELECCIONAR TIPO DE SERVICIO</button></div></div>';
					var panelSelloOriginal = '<div class="row" id="' + codigo_trazabilidad + '_panelSelloOriginal" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"><br/><h3 style="font-weight: bold; color: green;" >Apertura</h3><br/><h5>Sello actual del contenedor: ' + contenedor + '</h5><input id="' + codigo_trazabilidad + '_txtSelloActual" type="text" class="form-control" style="font-weight: bold; font-size: 18pt; color: green;"/></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 5%;"><button id="' + codigo_trazabilidad + '_btnSeleccionarTipoServicio" class="btn btn-lg btn-2x btn-warning text-center"><i class="fa fa-tasks"/><br/> SELECCIONAR TIPO DE SERVICIO </button></div></div>';
					var modalEyR = '<div class="modal" data-backdrop="static" data-keyboard="false" id="' + codigo_trazabilidad + '_modalEyR"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h4 class="modal-title">EIR</h4><button type="button" class="close" data-dismiss="modal">&times;</button></div><div class="modal-body"><image id="' + codigo_trazabilidad +'_imgContenedor"  class="img img-fluid img-center" style="margin-left: auto; margin-right: auto; display: block; width: 50%;" src="img/container.png"><div class="row"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><label for="' + codigo_trazabilidad + '_selectEyRpiso">Piso</label><select id="' + codigo_trazabilidad + '_selectEyRpiso" class="form-control">' + optDanosContenedor + '</select></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><label for="' + codigo_trazabilidad + '_selectEyRtecho">Techo</label><select id="' + codigo_trazabilidad + '_selectEyRtecho" class="form-control">' + optDanosContenedor + '</select></div></div><div class="row"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><label for="' + codigo_trazabilidad + '_selectEyRizquierda">Izquierda</label><select id="' + codigo_trazabilidad + '_selectEyRizquierda" class="form-control">' + optDanosContenedor + '</select></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><label for="' + codigo_trazabilidad + '_selectEyRderecha">Derecha</label><select id="' + codigo_trazabilidad + '_selectEyRderecha" class="form-control">' + optDanosContenedor + '</select></div></div><div class="row"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><label for="' + codigo_trazabilidad + '_selectEyRfondo">Fondo</label><select id="' + codigo_trazabilidad + '_selectEyRfondo" class="form-control">' + optDanosContenedor + '</select></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><label for="' + codigo_trazabilidad + '_selectEyRfrente">Frente / Puerta</label><select id="' + codigo_trazabilidad + '_selectEyRfrente" class="form-control">' + optDanosContenedor + '</select></div></div><div class="row"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"><label for="' + codigo_trazabilidad + '_textareaComentariosEyR">Comentarios</label><textarea rows="3" id="' + codigo_trazabilidad + '_textareaComentariosEyR" class="form-control"/></div></div></div><div class="modal-footer"><button type="button" id="' + codigo_trazabilidad + '_btnGuardarEyR" class="btn btn-success" style="background-color: green; border-color: green;" data-dismiss="modal"><i class="fa fa-save"/> Guardar </button></div></div></div></div>';
					var panelTipoServicioPersonal = '<div class="row" id="' + codigo_trazabilidad + '_panelTipoServicioPersonal1" style="width: 100%; height: 100%; min-height: 100%; padding: 10% 10% 2% 10%; display: none"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"><h3 style="color: green; font-weight: bold;">Apertura</h3><br/></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><h4>Tipo de servicio</h4><select id="' + codigo_trazabilidad + '_selectTipoServicio" class="form-control">' + optTipoServicio + '</select></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center" id="' + codigo_trazabilidad + '_divCantidadRetirar"><h4>Cantidad a retirar</h4><select id="' + codigo_trazabilidad + '_selectCantidadRetirar" class="form-control">' + optCantidadRetirar + '</select></div></div><div class="row" id="' + codigo_trazabilidad + '_panelTipoServicioPersonal3" style="width: 100%; height: 100%; min-height: 100%; padding: 0% 10% 2% 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><h4> Revisión no intrusiva </h6><select id="' + codigo_trazabilidad + '_selectRevisionIntrusiva" class="form-control" ><option value="-1">Seleccione una opción</option><option value="0">No</option><option value="1">Si</option></select></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center" id="' + codigo_trazabilidad + '_divCantidadRetirar2"><h4> Observaciones desconsolidación </h6><textarea rows="3" id="' + codigo_trazabilidad + '_txtObsDesconsolidacion" class="form-control" ></textarea></div></div><div class="row" id="' + codigo_trazabilidad + '_panelTipoServicioPersonal2" style="width: 100%; height: 100%; min-height: 100%; padding: 0% 10% 10% 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><h4> Personal presente </h6><select id="' + codigo_trazabilidad + '_selectPersonalPresente" class="form-control" multiple title="Selecciona al personal presente en la revisión">' + optPersonalEmpresa + '</select></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><h4> Vista fiscal </h6><select id="' + codigo_trazabilidad + '_idVistaFiscal" class="form-control" data-live-search="true">' + optVistasFiscales + '</select></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 20px;"><button id="' + codigo_trazabilidad + '_btnIniciarDesconsolidacion" class="btn btn-lg btn-2x btn-warning text-center"><i class="fa fa-unlink"/><br/>INICIAR DESCONSOLIDACIÓN</button></div></div>';
					var panelEdoMcia = '<div class="row" id="' + codigo_trazabilidad + '_edoMcia" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h3 style="color: green; font-weight: bold;">Desconsolidación</h3><h4>Estado de la mercancía:</h4><textarea id="' + codigo_trazabilidad + '_txtEdoMcia" class="form-control" style="font-weight: bold; font-size: 14pt; color: green;" rows="3" placeholder="Observaciones o comentarios respecto al estado de la mercancía o carga que se desconsolida"></textarea></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 20px;"><button id="' + codigo_trazabilidad + '_btnIniciarInspeccion" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-eye"></i><br/>INICIAR INSPECCIÓN</button></div></div>';
					var panelInspeccion = '<div class="row" id="' + codigo_trazabilidad + '_panelInspeccion" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h3 style="color: green; font-weight: bold;">Inspección</h3></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center" style="padding-top: 10px;"><h4>¿Ingresa binomio canino?</h4><div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="' + codigo_trazabilidad + '_optBinomioCanino" id="' + codigo_trazabilidad + '_optBinomioSI" value="1"/><label class="form-check-label" for="' + codigo_trazabilidad + '_optBinomioSI">SI</label></div><div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="' + codigo_trazabilidad + '_optBinomioCanino" id="' + codigo_trazabilidad + '_optBinomioNO" value="0"/><label class="form-check-label" for="' + codigo_trazabilidad + '_optBinomioNO">NO</label></div></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center" style="padding-top: 10px;"><h4>¿Se realiza muestreo de mercancia?</h4><div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="' + codigo_trazabilidad + '_optMuestreoMcia" id="' + codigo_trazabilidad + '_optMuestreoSI" value="1"/><label class="form-check-label" for="' + codigo_trazabilidad + '_optMuestreoSI">SI</label></div><div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="' + codigo_trazabilidad + '_optMuestreoMcia" id="' + codigo_trazabilidad + '_optMuestreoNO" value="0"/><label class="form-check-label" for="' + codigo_trazabilidad + '_optMuestreoNO">NO</label></div></div><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h3 style="color: green">Observaciones sobre muestreo: </h3><textarea class="form-control" id="' + codigo_trazabilidad + '_txtObsMuestreo" style="font-size: 16pt; font-weight: bold; color: green;"></textarea></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 20px;"><button id="' + codigo_trazabilidad + '_btnIniciarConsolidacion" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-cubes"/><br/> INICIAR CONSOLIDACIÓN</button></div></div>';
					//var panelRelMatUsados = '<div class="row" id="' + codigo_trazabilidad + '_relMatUsados" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h3 style="color: green; font-weight: bold;">Consolidación</h3></div><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-top: 10px;"><h4>Cliente a facturar (Importador):</h4><textarea style=" width: 100%; font-size: 14pt; font-weight: bold; color: green; padding: 1%;" rows="2" id="' + codigo_trazabilidad + '_txtClienteFacturar" class="form-control"/></textarea></div><div class="col-xs-12 col-sm-12 col-md-8 col-lg-8" style="padding-top: 10px;"><h4>Relación de materiales usados</h4><div id="' + codigo_trazabilidad + '_tablaMaterialesUsados" style="background-color: white; text-align: center; "><table class="table"><thead><tr style="background-color: #528933; font-weight: bold; color: white;"><th>Material</th><th>Cantidad</th><th></th></tr></thead><tbody><tr><td contenteditable="true"><select class="select form-control ' + codigo_trazabilidad + '_selectTipoMaterial"><option value="-1"> Seleccione una opción </option></select></td><td contenteditable="true">0</td><td contenteditable="false"> </td></tr></tbody></table></div></div><div class="col-xs-12 col-sm-12 col-md-4 col-lg-4" style="padding-top: 10px; padding-left: 0px;"><div class="col-xs-1 col-sm-1 col-md-1 col-lg-1" style="vertical-alignment: center;"><br/><br/><button class="btn btn-success text-center" id="' + codigo_trazabilidad + '_btnAgregarMaterial" style="background-color: #528933; border-color: #528933;"><i class="fa fa-plus" style="color: white"/></button></div></div><br/><br/><div style="text-align: center; display: block; margin-left: auto; margin-right: auto; padding-top: 20px;"><button id="' + codigo_trazabilidad + '_btnCierreContenedor" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-window-close"/><br/> CIERRE DE CONTENEDOR </button></div></div>';
					//var panelCapturaSelloNuevo = '<div class="row" id="' + codigo_trazabilidad +'_panelCapturaSelloNuevo" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"><h3 style="font-weight: bold; color: green;"> Cierre de contenedor </h3><h5>Nuevo sello del contenedor ' + contenedor + '</h5><input id="' + codigo_trazabilidad + '_txtSelloNuevo" type="text" class="form-control" style="font-weight: bold; font-size: 18pt; color: green;" maxlength="15"/></div><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center" style=" padding: 5%; vertical-alignment: center;"><button id="' + codigo_trazabilidad + '_btnFinalizaServicio" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-check"/> <br/> FINALIZAR SERVICIO</button></div></div>';
					var panelCapturaSelloNuevo = '<div class="row" id="' + codigo_trazabilidad +'_panelCapturaSelloNuevo" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><h3 style="font-weight: bold; color: green;"> Cierre de contenedor </h3><br/><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12"><div class="row"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6"><h5>Sello nuevo para contenedor ' + contenedor.toUpperCase() + ':</h5><input id="' + codigo_trazabilidad + '_txtSelloNuevo" type="text" class="form-control" style="font-weight: bold; font-size: 18pt; color: green;"/></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><button id="' + codigo_trazabilidad + '_btnEyR" class="btn btn-success text-center" style="width: 50%; height: 120%; background-color: orange; border-color: orange; font-weight: bold;" data-toggle="modal" data-target="#' + codigo_trazabilidad + '_modalEyR"><i class="fa fa-truck"/><br/> EIR </button></div></div></div><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center" style=" padding: 5%; vertical-alignment: center;"><button id="' + codigo_trazabilidad + '_btnFinalizaServicio" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-check"/><br/> FINALIZAR SERVICIO</button></div></div>';
					var panelInspeccionOcular = '<div class="row" id="' + codigo_trazabilidad + '_panelInspeccionOcular" style="width: 100%; height: 100%; min-height: 100%; padding: 10%; display: none;"><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center"><h3 style="font-weight: bold; color: green;" id="txtContenedor">' + contenedor + '</h3><br/><h5>Observaciones sobre la inspección ocular:</h5><textarea style="font-weight: bold; font-size: 16pt; color: green; " rows="2" id="' + codigo_trazabilidad + '_txtObsInspOcular" type="text" class="form-control"/><h6>Cuando el vista fiscal termine la inspección visual, haga clic en CIERRE DE CONTENEDOR para proceder a capturar el nuevo sello</h6></div><div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center" style="vertical-alignment: center;"><button id="' + codigo_trazabilidad + '_btnCierreContenedorOcular" class="btn btn-lg btn-2x btn-success text-center" style="background-color: #528933; border-color: #528933;"><i class="fa fa-window-close"/> <br/> CIERRE DE CONTENEDOR </button></div></div>';
					
					//paneles de navegacion y timer del ultimo evento
					var panelTimer = '<div id="' + codigo_trazabilidad + '_panelTimer" style="width: 100%; background-color: white; display: none;"><div class="row"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center"><h5 style="color: black; font-weight: bold;">Estado del servicio:</h5><h5 style="color: orange; font-weight: bold;" id="' + codigo_trazabilidad + '_txtLabelEtapaActual"></h5></div><div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 text-center" style=""><h5 style="color: black; font-weight: bold;">Tiempo estado actual:</h5><h5 style="color: orange; font-weight: bold;" id="' + codigo_trazabilidad + '_txtTimerEtapaActual"></h5></div><div class="col-xs-12 col-sm-12 col-md-2 col-lg-2 text-right" style=""><a href="javascript:cancelarServicio('+ codigo_trazabilidad +')" class="btn btn-danger" style="margin-right: 10px;border-radius: 50px;"><i class="fa fa-close" aria-hidden="true"></i></a></div><hr style="width: 100%;" /></div></div>';
					var panelNavegacion = '';
					$("#panelDetalle_" + codigo_trazabilidad).append(panelTimer);
					$("#panelDetalle_" + codigo_trazabilidad).append(panelNavegacion);
					obtenerEventosServicio(codigo_trazabilidad);


					if (Number(tipo) == 1){
						//CARGA CONTENERIZADA
							
							//1 - Append de los modulos necesarios
							$("#panelDetalle_" + codigo_trazabilidad).append(panelApertura);
							//$("#panelDetalle_" + codigo_trazabilidad).append(panelSelloEyR);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelSelloOriginal);
							$("#panelDetalle_" + codigo_trazabilidad).append(modalEyR);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelTipoServicioPersonal);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelEdoMcia);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelInspeccion);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelRelMatUsados);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelCapturaSelloNuevo);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelInspeccionOcular);

							$("#" + codigo_trazabilidad + "_btnAgregarMaterial").on("click", function(e){
								console.log("Boton apretado!!");
								agregarColumnaMaterialUsado("#" + codigo_trazabilidad + '_tablaMaterialesUsados', codigo_trazabilidad, "");
							});
							$("#" + codigo_trazabilidad + '_tablaMaterialesUsados').SetEditable();
							
							//2 - Definir eventos y flujo de aparicion de los modulos segun datos capturados y tipo de servicio
							
							//Modulo apertura (inicio del servicio)
							$("#" + codigo_trazabilidad + '_btnAperturaServicio').on("click", function(e){
								cambiarEstadoServicio(codigo_trazabilidad,2);
								
								$("#" + codigo_trazabilidad + '_panelApertura').fadeOut(100, function(e){
									$("#" + codigo_trazabilidad + '_panelSelloOriginal').fadeIn(100);
								});
							});
							
							//Modulo captura de sello existente
							$("#" + codigo_trazabilidad + '_btnSeleccionarTipoServicio').on("click", function(e){
								if ($("#" + codigo_trazabilidad + "_txtSelloActual").val().length > 0){
									//if (Number(localStorage.getItem(codigo_trazabilidad + "_EIROK")) == 1 && )
									guardarSelloOriginal(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtSelloActual").val());

									$("#" + codigo_trazabilidad + '_panelSelloOriginal').fadeOut(100, function(e){
										$("#" + codigo_trazabilidad + "_selectTipoServicio").selectpicker();
										$("#" + codigo_trazabilidad + "_selectRevisionIntrusiva").selectpicker();
										$("#" + codigo_trazabilidad + "_selectCantidadRetirar").selectpicker();
										$("#" + codigo_trazabilidad + "_selectPersonalPresente").selectpicker();
										$("#" + codigo_trazabilidad + "_idVistaFiscal").selectpicker();
										
										//Ocultar cantidad a retirar en inspeccion ocular
										$("#" + codigo_trazabilidad + '_selectTipoServicio').on("change", function(e){
											(Number($("#" + codigo_trazabilidad + '_selectTipoServicio').val()) == 1) ? $("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeIn(100) : $("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeOut(100);
											if ((Number($("#" + codigo_trazabilidad + '_selectTipoServicio').val()) == 1)){
												$("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeIn(100);
												$("#" + codigo_trazabilidad + '_divCantidadRetirar2').fadeIn(100);
											} else {
												$("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeOut(100);
												$("#" + codigo_trazabilidad + '_divCantidadRetirar2').fadeOut(100);
												$("#" + codigo_trazabilidad + "_selectCantidadRetirar").val(-1);
												$("#" + codigo_trazabilidad + "_txtObsDesconsolidacion").text("");
											}
										});
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeIn(100);
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeIn(100);
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeIn(100);
									});

								} else {
									swal("Por favor captura el sello original (actual) antes de continuar");
								}
							});
							
							//Eventos del modal de captura del EyR del contenedor
							$("#" + codigo_trazabilidad + "_btnEyR").on("click", function(e){
								$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/container.png");
							});
							
							$("#" + codigo_trazabilidad + "_btnGuardarEyR").on("click", function(e){
								if ($("#" + codigo_trazabilidad + "_selectEyRpiso").val() > 0 && $("#" + codigo_trazabilidad + "_selectEyRtecho").val() > 0 && $("#" + codigo_trazabilidad + "_selectEyRizquierda").val() > 0 && $("#" + codigo_trazabilidad + "_selectEyRderecha").val() > 0 && $("#" + codigo_trazabilidad + "_selectEyRfondo").val() > 0 && $("#" + codigo_trazabilidad + "_selectEyRfrente").val() > 0) {
									guardarLadoEIR(codigo_trazabilidad, 1, $("#" + codigo_trazabilidad + "_selectEyRpiso").val());
									guardarLadoEIR(codigo_trazabilidad, 2, $("#" + codigo_trazabilidad + "_selectEyRtecho").val());
									guardarLadoEIR(codigo_trazabilidad, 3, $("#" + codigo_trazabilidad + "_selectEyRizquierda").val());
									guardarLadoEIR(codigo_trazabilidad, 4, $("#" + codigo_trazabilidad + "_selectEyRderecha").val());
									guardarLadoEIR(codigo_trazabilidad, 5, $("#" + codigo_trazabilidad + "_selectEyRfondo").val());
									guardarLadoEIR(codigo_trazabilidad, 6, $("#" + codigo_trazabilidad + "_selectEyRfrente").val());

									//insertar obs si se capturaron
									if ($("#" + codigo_trazabilidad + "_textareaComentariosEyR").val().length > 0 && $("#" + codigo_trazabilidad + "_textareaComentariosEyR").val().replace(" ","") != "") {
										guardarLadoEIR(codigo_trazabilidad, 7, $("#" + codigo_trazabilidad + "_textareaComentariosEyR").val());
									}

									localStorage.setItem(codigo_trazabilidad + "_EIROK" , "1");
								} else {
									swal("Error", "Captura el estado de todos los lados en el EIR");
									localStorage.setItem(codigo_trazabilidad + "_EIROK", "0");
								}
							});
							
							$("#" + codigo_trazabilidad + "_selectEyRpiso").on("click", function(e){
								if ($("#" + codigo_trazabilidad+ "_imgContenedor").attr("src") != "img/eyr/piso.png"){
									$("#" + codigo_trazabilidad+ "_imgContenedor").fadeOut("0", function(e){
										$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/eyr/piso.png");
										$("#" + codigo_trazabilidad+ "_imgContenedor").fadeIn("10");
									});
								}
							});
							
							$("#" + codigo_trazabilidad + "_selectEyRtecho").on("click", function(e){
								if ($("#" + codigo_trazabilidad+ "_imgContenedor").attr("src") != "img/eyr/techo.png"){
									$("#" + codigo_trazabilidad+ "_imgContenedor").fadeOut("0", function(e){
										$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/eyr/techo.png");
										$("#" + codigo_trazabilidad+ "_imgContenedor").fadeIn("0");
									});
								}
								
							});
							
							$("#" + codigo_trazabilidad + "_selectEyRfondo").on("click", function(e){
								if ($("#" + codigo_trazabilidad+ "_imgContenedor").attr("src") != "img/eyr/fondo.png"){
									$("#" + codigo_trazabilidad+ "_imgContenedor").fadeOut("0", function(e){
										$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/eyr/fondo.png");
										$("#" + codigo_trazabilidad+ "_imgContenedor").fadeIn("0");
									});
								}
							});
							
							$("#" + codigo_trazabilidad + "_selectEyRizquierda").on("click", function(e){
								if ($("#" + codigo_trazabilidad+ "_imgContenedor").attr("src") != "img/eyr/izquierda.png"){
									$("#" + codigo_trazabilidad+ "_imgContenedor").fadeOut("0", function(e){
										$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/eyr/izquierda.png");
										$("#" + codigo_trazabilidad+ "_imgContenedor").fadeIn("0");
									});
								}
							});
							
							$("#" + codigo_trazabilidad + "_selectEyRderecha").on("click", function(e){
								if ($("#" + codigo_trazabilidad+ "_imgContenedor").attr("src") != "img/eyr/derecha.png"){
									$("#" + codigo_trazabilidad+ "_imgContenedor").fadeOut("0", function(e){
										$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/eyr/derecha.png");
										$("#" + codigo_trazabilidad+ "_imgContenedor").fadeIn("0");
									});
								}
							});
							
							$("#" + codigo_trazabilidad + "_selectEyRfrente").on("click", function(e){
								if ($("#" + codigo_trazabilidad+ "_imgContenedor").attr("src") != "img/eyr/frente.png"){
									$("#" + codigo_trazabilidad+ "_imgContenedor").fadeOut("0", function(e){
										$("#" + codigo_trazabilidad+ "_imgContenedor").attr("src","img/eyr/frente.png");
										$("#" + codigo_trazabilidad+ "_imgContenedor").fadeIn("0");
									});
								}
							});
							
							//Modulo de captura de tipoServicio, Personal de MOVERSA que participara en servicio, Vista Fiscal asignado al servicio, 
							//Y cantidad a retirar del contenedor (en caso de ser inspeccion con revision)
							$("#" + codigo_trazabilidad + '_btnIniciarDesconsolidacion').on("click", function(e){
								//validar que todos los datos esten llenos
								var personalPresente = $("#" + codigo_trazabilidad + "_selectPersonalPresente").val();
								console.log(personalPresente);
								var tmpTipoServicio = Number($("#" + codigo_trazabilidad + "_selectTipoServicio").val());
								var tmpCantidadRetirar = Number($("#" + codigo_trazabilidad + "_selectCantidadRetirar").val());
								var tmpRevisionIntrusiva = Number($("#" + codigo_trazabilidad + "_selectRevisionIntrusiva").val());
								var tmpVistaFiscal = $("#" + codigo_trazabilidad + "_idVistaFiscal").val();
								var obsDesconsolidacion = $("#" + codigo_trazabilidad + "_txtObsDesconsolidacion").val();
								console.log("SE OBTIENEN COMENTARIOS DE DESCONSOLIDACION:" + obsDesconsolidacion);
								if(personalPresente.length > 0 && tmpTipoServicio > 0 && (tmpCantidadRetirar > 0 || tmpTipoServicio == 2) && tmpVistaFiscal > 0 && tmpRevisionIntrusiva >= 0){
									//cambiarEstadoServicio(codigo_trazabilidad, 3);
									guardarTipoServicio(codigo_trazabilidad, tmpTipoServicio, tmpRevisionIntrusiva);
									if (tmpCantidadRetirar > 0) {
										guardarCantidadRetirar(codigo_trazabilidad, tmpCantidadRetirar);
										//20112019 - Guardar observaciones de desconsolidacion
										guardarObsDesconsolidacion(codigo_trazabilidad, obsDesconsolidacion);
									}
									guardarVistaFiscal(codigo_trazabilidad, tmpVistaFiscal);

									for(var w = 0; w < personalPresente.length ; w++){
										if (Number(personalPresente[w]) >= 0) {
											guardarPersonalMoversaServicio(codigo_trazabilidad, Number(personalPresente[w]), w);
										}
									}

									//ocultar controles y mostrsr sigueinte etapa
									if (tmpTipoServicio == 2){
										cambiarEstadoServicio(codigo_trazabilidad, 4);
										//Directamente al panel de inspección ocular
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeOut(50, function(e){
											$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeOut(50, function(e){
			
												$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeOut(50);
												$("#" + codigo_trazabilidad + '_panelInspeccionOcular').fadeIn(100);
											});
										});

									} else {
										cambiarEstadoServicio(codigo_trazabilidad, 3);
										//Continuamos a la inspeccion completa
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeOut(50, function(e){
											$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeOut(50, function(e){
			
												$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeOut(50);
												$("#" + codigo_trazabilidad + '_edoMcia').fadeIn(100);
											});
										});
									}

									// $("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeOut(50, function(e){
									// 	$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeOut(50, function(e){

									// 		$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeOut(50);
									// 		$("#" + codigo_trazabilidad + '_edoMcia').fadeIn(100);
									// 	});
									// });

								} else {
									swal("Error","Por favor captura todos los campos antes de continuar. Selecciona al menos a un miembro del personal");
								}

							});
							
							//Modulo de desconsolidación (captura de comentarios sobre estado de mercancia)
							$("#" + codigo_trazabilidad + '_btnIniciarInspeccion').on("click", function(e){
								
								if ($("#" + codigo_trazabilidad + "_txtEdoMcia").val().length > 0){
									guardarEdoMcia(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtEdoMcia").val());
									cambiarEstadoServicio(codigo_trazabilidad, 4);
									$("#" + codigo_trazabilidad + '_edoMcia').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_panelInspeccion').fadeIn(100);
									});
								} else {
									cambiarEstadoServicio(codigo_trazabilidad, 4);
									$("#" + codigo_trazabilidad + '_edoMcia').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_panelInspeccion').fadeIn(100);
									});
									
								}
							});

							//Modulo de inspección ocular (captura de comentarios sobre estado de mercancia?)
							$("#" + codigo_trazabilidad + '_btnCierreContenedorOcular').on("click", function(e){
								
								if ($("#" + codigo_trazabilidad + "_txtObsInspOcular").val().length > 0){
									guardarEdoMcia(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtObsInspOcular").val());
									cambiarEstadoServicio(codigo_trazabilidad, 6);
									$("#" + codigo_trazabilidad + '_panelInspeccionOcular').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100);
									});
								} else {
									cambiarEstadoServicio(codigo_trazabilidad, 6);
									$("#" + codigo_trazabilidad + '_panelInspeccionOcular').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100);
									});
									
								}
							});
							
							//Modulo de inspección (captura de ingreso del binomio canino)
							$("#" + codigo_trazabilidad + '_btnIniciarConsolidacion').on("click", function(e){
								cambiarEstadoServicio(codigo_trazabilidad, 5);
								var tmpcaninochecked = $('input[name=' + codigo_trazabilidad + '_optBinomioCanino]:checked').val();
								var tmpmuestreochecked = $('input[name=' + codigo_trazabilidad + '_optMuestreoMcia]:checked').val();
								if (tmpcaninochecked !== null && tmpmuestreochecked !== null){

									var tmpobsmuestreo = $("#" + codigo_trazabilidad + "_txtObsMuestreo").val();
									guardarBinomioCanino(codigo_trazabilidad, tmpcaninochecked, tmpmuestreochecked, tmpobsmuestreo);
									//guardarBinomioCanino(codigo_trazabilidad, tmpcaninochecked, tmpmuestreochecked, "");

									// //ocultr controles y mostrar siguiente sección
									// //evento para agregar nuevas filas a la tabla de materiales usados
									// $("#" + codigo_trazabilidad + "_btnAgregarMaterial").on("click", function(e){
									// 	console.log("Boton apretado!!");
									// 	agregarColumnaMaterialUsado("#" + codigo_trazabilidad + '_tablaMaterialesUsados', codigo_trazabilidad, "");
									// });
									
									//inicializar tabla editable
									//$("#" + codigo_trazabilidad + '_tablaMaterialesUsados').SetEditable();
									
									$("#" + codigo_trazabilidad + '_panelInspeccion').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_relMatUsados').fadeIn(100);
									});

								} else {
									swal ("Error","Por favor especifica si ingresa binomio canino, y si hay muestreo de mercancía.");
								}

							});
							
							//Modulo de consolidacion (captura de listado de insumos usados en el servicio)
							$("#" + codigo_trazabilidad + '_btnCierreContenedor').on("click", function(e){
								cambiarEstadoServicio(codigo_trazabilidad, 6);
								
								if ($("#" + codigo_trazabilidad + "_txtClienteFacturar").val().length > 0){
									
									
									if ($('#' + codigo_trazabilidad + '_tablaMaterialesUsados > table').find('tbody').children("tr").length > 0) {
										$('#' + codigo_trazabilidad + '_tablaMaterialesUsados > table').find('tbody').children("tr").each(function(w) {
											var material = $(this).find("td:nth-child(1) > select").val();
											var cantidad = $(this).find("td:nth-child(2)").text();
											var obs = $(this).find("td:nth-child(3)").text();
											
											console.log("Material -->" + material);
											guardarMatUsado(codigo_trazabilidad, material, cantidad, w);
										});

										$("#" + codigo_trazabilidad + '_relMatUsados').fadeOut(50, function(e){
											$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100);
										});
									} else {
										wal("Datos faltantes","Debe haber al menos un material cargado","warning");
									}

                                    guardarClienteFacturar(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtClienteFacturar").val());	

								} else {
									swal("Datos faltantes","Por favor especifica el cliente a facturar","warning");
								}

							});
							
							//Modulo finalizar servicio (captura del nuevo sello del contenedor y remover servicio de listado por haber finalizado
							$("#" + codigo_trazabilidad + '_btnFinalizaServicio').on("click", function(e){
					
								if (Number(localStorage.getItem(codigo_trazabilidad + "_EIROK")) == 1 && $("#"+ codigo_trazabilidad + "_txtSelloNuevo").val().length > 0 && $($("#"+ codigo_trazabilidad + "_txtSelloNuevo")).val().replace(" ","") != "") {
									guardarSelloNuevo(codigo_trazabilidad, $("#"+ codigo_trazabilidad + "_txtSelloNuevo").val());
									cambiarEstadoServicio(codigo_trazabilidad, 7);
								} else {
									swal ("Error", "Por favor captura el EIR y el nuevo sello del contenedor");
								}
								
								$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeOut(50, function(e){
									//swal("Fin del servicio","Servicio finalizado correctamente!"); // cambiar a SweetAlert, esto se ve feo
									$("#txtResultadoServicio").text("Servicio finalizado correctamente");
									//quitar pestaña y panel de la pagina y de tabla
									$("#panelDetalle_" + codigo_trazabilidad).remove();
									$("#tabDetalle_" + codigo_trazabilidad).remove();
									$("#divTablaServiciosProgramados").collapse("show");
									
									//remover fila de la tabla de servicios programados
									fila.remove();
								});
							});

							if (Number(status_servicio) > 1) {
								consultaDetalleServicio(codigo_trazabilidad);
								switch(Number(status_servicio)){
									case 2: $("#" + codigo_trazabilidad + '_panelSelloOriginal').fadeIn(100); break;
									case 3: $("#" + codigo_trazabilidad + '_edoMcia').fadeIn(100); break;
									case 4: $("#" + codigo_trazabilidad + '_panelInspeccion').fadeIn(100); break;
									case 5: $("#" + codigo_trazabilidad + '_relMatUsados').fadeIn(100); break;
									case 6: $("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100); break;
								}
							} else {
								$("#" + codigo_trazabilidad + '_panelApertura').fadeIn(100);	
							}
							//$("#" + codigo_trazabilidad + '_panelApertura').fadeIn(100);	
						
					} else {
						//CARGA SUELTA
						
							//1 - Append de los modulos necesarios
							$("#panelDetalle_" + codigo_trazabilidad).append(panelApertura);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelTipoServicioPersonal);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelEdoMcia);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelInspeccion);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelRelMatUsados);
							$("#panelDetalle_" + codigo_trazabilidad).append(panelInspeccionOcular);

							$("#" + codigo_trazabilidad + "_btnAgregarMaterial").on("click", function(e){
								console.log("Boton apretado!!");
								agregarColumnaMaterialUsado("#" + codigo_trazabilidad + '_tablaMaterialesUsados', codigo_trazabilidad, "");
							});
							$("#" + codigo_trazabilidad + '_tablaMaterialesUsados').SetEditable();

							//2 - Definir eventos y flujo de aparicion de los modulos segun datos capturados y tipo de servicio

							//Modulo apertura (inicio del servicio)
							$("#" + codigo_trazabilidad + '_btnAperturaServicio').on("click", function(e){
								cambiarEstadoServicio(codigo_trazabilidad,2);
								
								$("#" + codigo_trazabilidad + '_panelApertura').fadeOut(100, function(e){
									$("#" + codigo_trazabilidad + "_selectTipoServicio").selectpicker();
									$("#" + codigo_trazabilidad + "_selectRevisionIntrusiva").selectpicker();
									$("#" + codigo_trazabilidad + "_selectCantidadRetirar").selectpicker();
									$("#" + codigo_trazabilidad + "_selectPersonalPresente").selectpicker();
									$("#" + codigo_trazabilidad + "_idVistaFiscal").selectpicker();
									
									//Ocultar cantidad a retirar en inspeccion ocular
									$("#" + codigo_trazabilidad + '_selectTipoServicio').on("change", function(e){
										(Number($("#" + codigo_trazabilidad + '_selectTipoServicio').val()) == 1) ? $("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeIn(100) : $("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeOut(100);
										if ((Number($("#" + codigo_trazabilidad + '_selectTipoServicio').val()) == 1)){
											$("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeIn(100);
										} else {
											$("#" + codigo_trazabilidad + '_divCantidadRetirar').fadeOut(100);
											$("#" + codigo_trazabilidad + "_selectCantidadRetirar").val(-1);
										}
									});
									
									$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeIn(100);
									$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeIn(100);
									$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeIn(100);
								});
							});

							//Modulo de captura de tipoServicio, personal de la empresa que participa, Vista Fiscal asignado y cantidad a retirar del contenedor (en caso de ser inspeccion con revision)
							$("#" + codigo_trazabilidad + '_btnIniciarDesconsolidacion').on("click", function(e){
								//validar que todos los datos esten llenos
								var personalPresente = $("#" + codigo_trazabilidad + "_selectPersonalPresente").val();
								console.log(personalPresente);
								var tmpTipoServicio = Number($("#" + codigo_trazabilidad + "_selectTipoServicio").val());
								var tmpCantidadRetirar = Number($("#" + codigo_trazabilidad + "_selectCantidadRetirar").val());
								var tmpRevisionIntrusiva = Number($("#" + codigo_trazabilidad + "_selectRevisionIntrusiva").val());
								var tmpVistaFiscal = $("#" + codigo_trazabilidad + "_idVistaFiscal").val();
								var obsDesconsolidacion = $("#" + codigo_trazabilidad + "_txtObsDesconsolidacion").val();
								console.log("SE OBTIENEN COMENTARIOS DE DESCONSOLIDACION:" + obsDesconsolidacion);
								if(personalPresente.length > 0 && tmpTipoServicio > 0 && (tmpCantidadRetirar > 0 || tmpTipoServicio == 2) && tmpVistaFiscal > 0 && tmpRevisionIntrusiva >= 0){
									// cambiarEstadoServicio(codigo_trazabilidad, 3);
									guardarTipoServicio(codigo_trazabilidad, tmpTipoServicio, tmpRevisionIntrusiva);
									if (tmpCantidadRetirar > 0) {
										guardarCantidadRetirar(codigo_trazabilidad, tmpCantidadRetirar);
										//20112019 - Guardar observaciones de desconsolidacion
										guardarObsDesconsolidacion(codigo_trazabilidad, obsDesconsolidacion);
										
									}
									guardarVistaFiscal(codigo_trazabilidad, tmpVistaFiscal);

									for(var w = 0; w < personalPresente.length ; w++){
										if (Number(personalPresente[w]) >= 0) {
											guardarPersonalMoversaServicio(codigo_trazabilidad, Number(personalPresente[w]), w);
										}
									}

									//ocultar controles y mostrsr sigueinte etapa
									if (tmpTipoServicio == 2){
										cambiarEstadoServicio(codigo_trazabilidad, 4);
										//Directamente al panel de inspección ocular
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeOut(50, function(e){
											$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeOut(50, function(e){

												$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeOut(50);
												$("#" + codigo_trazabilidad + '_panelInspeccionOcular').fadeIn(100);
											});
										});

									} else {
										cambiarEstadoServicio(codigo_trazabilidad, 3);
										//Continuamos a la inspeccion completa
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeOut(50, function(e){
											$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeOut(50, function(e){

												$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeOut(50);
												$("#" + codigo_trazabilidad + '_edoMcia').fadeIn(100);
											});
										});
									}

								} else {
									swal("Error","Por favor captura todos los campos antes de continuar. Selecciona al menos a un miembro del personal");
								}

							});

							//Modulo de desconsolidación (captura de comentarios sobre estado de mercancia)
							$("#" + codigo_trazabilidad + '_btnIniciarInspeccion').on("click", function(e){
								
								if ($("#" + codigo_trazabilidad + "_txtEdoMcia").val().length > 0) { 
									guardarEdoMcia(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtEdoMcia").val()); 
								}
								cambiarEstadoServicio(codigo_trazabilidad, 4);
								$("#" + codigo_trazabilidad + '_edoMcia').fadeOut(50, function(e){
									$("#" + codigo_trazabilidad + '_panelInspeccion').fadeIn(100);
								});
								
							});

							//Modulo de inspección ocular (captura de comentarios sobre estado de mercancia?)
							$("#" + codigo_trazabilidad + '_btnCierreContenedorOcular').on("click", function(e){
								
								if ($("#" + codigo_trazabilidad + "_txtObsInspOcular").val().length > 0){
									guardarEdoMcia(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtObsInspOcular").val());
									cambiarEstadoServicio(codigo_trazabilidad, 6);
									$("#" + codigo_trazabilidad + '_panelInspeccionOcular').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100);
									});
								} else {
									cambiarEstadoServicio(codigo_trazabilidad, 6);
									$("#" + codigo_trazabilidad + '_panelInspeccionOcular').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100);
									});
									
								}
							});

							//Modulo de inspección (captura de ingreso del binomio canino)
							$("#" + codigo_trazabilidad + '_btnIniciarConsolidacion').on("click", function(e){
								cambiarEstadoServicio(codigo_trazabilidad, 5);
								var tmpcaninochecked = $('input[name=' + codigo_trazabilidad + '_optBinomioCanino]:checked').val();
								var tmpmuestreochecked = $('input[name=' + codigo_trazabilidad + '_optMuestreoMcia]:checked').val();
								if (tmpcaninochecked !== null && tmpmuestreochecked !== null){

									var tmpobsmuestreo = $("#" + codigo_trazabilidad + "_txtObsMuestreo").val();
									guardarBinomioCanino(codigo_trazabilidad, tmpcaninochecked, tmpmuestreochecked, tmpobsmuestreo);
									//guardarBinomioCanino(codigo_trazabilidad, tmpcaninochecked, tmpmuestreochecked, "");

									// //ocultr controles y mostrar siguiente sección
									// //evento para agregar nuevas filas a la tabla de materiales usados
									// $("#" + codigo_trazabilidad + "_btnAgregarMaterial").on("click", function(e){
									// 	console.log("Boton apretado!!");
									// 	agregarColumnaMaterialUsado("#" + codigo_trazabilidad + '_tablaMaterialesUsados', codigo_trazabilidad, "");
									// });
									
									//inicializar tabla editable
									//$("#" + codigo_trazabilidad + '_tablaMaterialesUsados').SetEditable();
									
									$("#" + codigo_trazabilidad + '_panelInspeccion').fadeOut(50, function(e){
										$("#" + codigo_trazabilidad + '_relMatUsados').fadeIn(100);
									});

								} else {
									swal ("Error","Por favor especifica si ingresa binomio canino, y si hay muestreo de mercancía.");
								}

							});

							//Modulo de consolidacion (captura de listado de insumos usados en el servicio)
							$("#" + codigo_trazabilidad + '_btnCierreContenedor').on("click", function(e){
								cambiarEstadoServicio(codigo_trazabilidad, 6);
							
								
								if ($("#" + codigo_trazabilidad + "_txtClienteFacturar").val().length > 0){
								

									//TODO: Validar que al menos haya un material capturado?
									$('#' + codigo_trazabilidad + '_tablaMaterialesUsados > table').find('tbody').children("tr").each(function(w) {
										var material = $(this).find("td:nth-child(1) > select").val();
										var cantidad = $(this).find("td:nth-child(2)").text();
										var obs = $(this).find("td:nth-child(3)").text();
										guardarMatUsado(codigo_trazabilidad, material, cantidad, w);
									});
									
									guardarClienteFacturar(codigo_trazabilidad, $("#" + codigo_trazabilidad + "_txtClienteFacturar").val());
									
									$("#" + codigo_trazabilidad + '_relMatUsados').fadeOut(50, function(e){
										//$("#" + codigo_trazabilidad + '_panelCapturaSelloNuevo').fadeIn(100);
										//swal("Fin del servicio","Servicio finalizado correctamente!"); 
										$("#txtResultadoServicio").text("Servicio finalizado correctamente");										
										//quitar pestaña y panel de la pagina y de tabla
										$("#panelDetalle_" + codigo_trazabilidad).remove();
										$("#tabDetalle_" + codigo_trazabilidad).remove();
										$("#divTablaServiciosProgramados").collapse("show");
									});


								} else {
									swal("Por favor especifica el cliente a facturar");
								}

                                cambiarEstadoServicio(codigo_trazabilidad, 7);
							});


							if (Number(status_servicio) > 1) {
								consultaDetalleServicio(codigo_trazabilidad);
								switch(Number(status_servicio)){
									//TODO: Probar flujo completo de carga suelta
									case 2: {
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal1').fadeIn(100);
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal2').fadeIn(100);
										$("#" + codigo_trazabilidad + '_panelTipoServicioPersonal3').fadeIn(100);
									}; break;
									case 3: $("#" + codigo_trazabilidad + '_edoMcia').fadeIn(100); break;
									case 4: $("#" + codigo_trazabilidad + '_panelInspeccion').fadeIn(100); break;
									case 5: $("#" + codigo_trazabilidad + '_relMatUsados').fadeIn(100); break;
									case 6: $("#" + codigo_trazabilidad + '_relMatUsados').fadeIn(100); break;
								}
							} else {
								$("#" + codigo_trazabilidad + '_panelApertura').fadeIn(100);	
							}
							//$("#" + codigo_trazabilidad + '_panelApertura').fadeIn(100);
					}
					
				} else {
					//no hacemos nada por que ya esta
					swal("Este servicio ya esta en las pestañas de la pagina. Por favor haga clic en su pestaña para capturar la información y ver temporizadores");
					
				}
			$("#divTablaServiciosProgramados").collapse("hide");
			$("#btnHideServicios").toggleClass("rotar_elemento_180");
			$("#tabDetalle_" + codigo_trazabilidad).trigger("click");
				
			});

			//FINALIZA EVENTO	
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function consultaDetalleServicio(codigo){
	//TODO: consultar en BD
	//TODO: llenar campos de los paneles del servicio no finalizado
}

//reloj de la ultima etapa
function actualizarTimer(codigo, evento) {
	clearInterval(window.t);

	// Tomar hora del ultimo evento del localstorage
	var anio = Number(evento.split(" ")[0].split("/")[2]);
	var mes = Number(evento.split(" ")[0].split("/")[1]) - 1;
	var dia = Number(evento.split(" ")[0].split("/")[0]);
	var horas = Number(evento.split(" ")[1].split(":")[0]);
	var minutos = Number(evento.split(" ")[1].split(":")[1]);
	var segundos  = Number(evento.split(" ")[1].split(":")[2]);
	var dateUltimoEvento = new Date(anio,mes,dia,horas,minutos,segundos);
	var dateActual = new Date();

	var diffsegundos = (dateActual - dateUltimoEvento) / 1000;
	var horas = checkTime(Math.floor(diffsegundos/60/60));
	var minutos = checkTime(Math.floor((diffsegundos - (horas*60*60)) / 60));
	var segundos = checkTime(Math.floor(diffsegundos - (horas * 60 * 60) - (minutos * 60)));
	//console.log("tiempo desde ultimo evento: " + horas + ":" + minutos + ":" + segundos);
	$("#" + codigo + "_txtTimerEtapaActual").text(horas + ":" + minutos + ":" + segundos);
	
	window.t = setInterval(function(){
		setTimeout(
		actualizarTimer(codigo, evento),
		1000);
	}, 1000);
	//var t = setInterval(actualizarTimer(codigo, evento), 10000);

  }
  function checkTime(i) {
	if (i < 10) {i = "0" + i};  // add zero in front of numbers < 10
	return i;
  }

//Obtiene listado de eventos y fecha de los ultimos eventos 
function obtenerEventosServicio(codigo){
	var datos = {
		pTipoOperacion: "obtenerEventosServicio",
		pIdServicio: codigo,
	};
	var validtime = 0;
	var ultimoevento = "";
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) {
			//llenar la etiqueta con info del ultimo servicio
			if (resp.transaccion == "1" && resp.datos != null) {
				$("#" + codigo + "_txtLabelEtapaActual").text(resp.datos[resp.datos.length - 1].nomtipoevento);
				var stringEvento = resp.datos[resp.datos.length - 1].fechahora;
				//localStorage.setItem(codigo_trazabilidad + "_tmpEvento", stringEvento);
				ultimoevento = stringEvento;
				validtime = 1;

			} else {
				$("#" + codigo + "_txtLabelEtapaActual").text("PROGRAMADO");
				$("#" + codigo + "_txtTimerEtapaActual").text("00:00:00");
			}
			$("#" + codigo + "_panelTimer").fadeIn(50);
			//evento del reloj
				//hora actual menos la hora del ultimo evento obtenido de BD
				//evento de actualización ¿cada segundo?
		},
		complete: function () {
			if (validtime == 1){
				actualizarTimer(codigo, ultimoevento);
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}


//ACTUALIZACION DATOS DEL SERVICIO
//Global
function cambiarEstadoServicio(codigo, evento){

	var datos = {
		pTipoOperacion: "cambiarEstadoServicio",
		pIdServicio: Number(codigo),
		pEvento: Number(evento)
	};

	console.log("Cambiando el estado del servicio..");
	console.log(datos);
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
				//swal("Cambio de estado exitoso!: " + resp.mensaje);
				//obtener el ultimo evento
				obtenerEventosServicio(codigo);
				//si el evento es menor a 7 mandamos notificacion
				if (Number(Number(evento) != 6)) {
					console.log("Enviando correo de notificación de evento..");
					
					//Se comenta para efectos de prueba
					//enviarNotificacion(codigo, (Number(evento)));
				}

			} else {
				swal("Error","No se pudo cambiar el estado del servicio: " + resp.mensaje);
			}
				
		},
		complete: function () {
			//Si se termina el servicio se manda a FACTURAR -> GHG
			if(parseInt(evento) === 7){
				facturarServicio(codigo);
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

//Apertura
function guardarSelloOriginal(codigo, selloOriginal){
	var datos = {
		pTipoOperacion: "guardarSelloOriginal",
		pIdServicio: codigo,
		pSelloOriginal: selloOriginal
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar el sello original:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function guardarLadoEIR(codigo, lado, status){
	var datos = {
		pTipoOperacion: "guardarLadoEIR",
		pIdServicio: codigo,
		pLado: lado,
		pStatus: status
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar correctamente la información del EIR del servicio:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});

}

function guardarTipoServicio(codigo, tipoServicio, revisionNoIntrusiva){
	var datos = {
		pTipoOperacion: "guardarTipoServicio",
		pIdServicio: codigo,
		pTipoServicio: tipoServicio,
		pRevisionNoIntrusiva: revisionNoIntrusiva
	};
	console.log("guardarTipoServicio: " + codigo + ", " + tipoServicio + ", " + revisionNoIntrusiva);
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar correctamente el tipo de servicio y la revision no intrusiva:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function guardarCantidadRetirar(codigo, cantidadARetirar){
	var datos = {
		pTipoOperacion: "guardarCantidadRetirar",
		pIdServicio: codigo,
		pIdDesMed: cantidadARetirar
	};
	
	console.log("Guardar cantidad a retirar: " + codigo + ", " + cantidadARetirar);
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar correctamente la cantidad a retirar:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function guardarObsDesconsolidacion(codigo, obsDesconsol){
	var datos = {
		pTipoOperacion: "guardarObsDesconsolidacion",
		pIdServicio: codigo,
		pObsDesconsol: obsDesconsol
	};
	
	console.log("Observaciones desconsolidacion servicio " + codigo + ": " + obsDesconsol);
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar correctamente comentario de desconsolidacion:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}


function guardarPersonalMoversaServicio(codigo, idPersonal, indice){
	//Repetir esta funcion para cada miembro del personal seleccionado en el select 
	var datos = {
		pTipoOperacion: "guardarPersonalMoversaServicio",
		pIdServicio: codigo,
		pIdPersonal: idPersonal,
		pIndice: indice
	};
	console.log("Insertando al personal codigo " + idPersonal + " al servicio con ID " + codigo + " indice " + indice );
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar el personal involucrado en el servicio:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});

}

function guardarVistaFiscal(codigo, idPersonalAduana){
	var datos = {
		pTipoOperacion: "guardarVistaFiscal",
		pIdServicio: codigo,
		pIdPersonalAduana: idPersonalAduana
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar correctamente al Vista Fiscal de Aduana:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

//Desconsolidación

function guardarEdoMcia(codigo, edoMcia){
	//servicios_actualizar_NotasCarga
	var datos = {
		pTipoOperacion: "guardarEdoMcia",
		pIdServicio: codigo,
		pEdoMcia: edoMcia
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar el personal el estado de la mercancia:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

//Revision/Inspeccion

function guardarBinomioCanino(codigo, usaCanino, usaMuestreo, obsMuestreo){
	//tambien incluye dato y comentarios de muestro de mercancia
	//servicios_actualizar_BinomioCanino
	//servicios_actualizar_NotasCarga
	var datos = {
		pTipoOperacion: "guardarBinomioCanino",
		pIdServicio: codigo,
		pUsaCanino: usaCanino,
		pUsaMuestreo: usaMuestreo,
		pObsMuestreo: obsMuestreo
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudieron guardar datos de la revisión/inspección:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

//Consolidacion

function guardarClienteFacturar(codigo, clientefacturar){
	//servicios_calculo_tarifas
	var datos = {
		pTipoOperacion: "guardarClienteFacturar",
		pIdServicio: codigo,
		pClienteFacturar: clientefacturar
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar el Cliente a Facturar:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});

}

function guardarMatUsado(codigo, material, cantidad, indice){
	//Repetir esta funcion para cada material insertado
	//servicios_material_insertar
	console.log("--> Insertamos MATERIAL");
	var datos = {
		pTipoOperacion: "guardarMatUsado",
		pIdServicio: codigo,
		pIdMaterial: material,
		pCantidad: cantidad,
		pIndice: indice
	};
	
	console.log(datos);
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		    console.log(resp);
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar el material usado:" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

//Cierre

function guardarSelloNuevo(codigo, selloNuevo){
	var datos = {
		pTipoOperacion: "guardarSelloNuevo",
		pIdServicio: codigo,
		pSelloOriginal: selloNuevo
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
		
			if (resp.transaccion > 0){
			} else {
				swal("Error","No se pudo guardar el nuevo sello para el contenedor :" + resp.mensaje);
			}
				
		},
		complete: function () {
			//detener indicador de carga
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}



function cancelarServicio(pNidServicio){
		
	var mensaje = "El servicio será cancelado y se tendra que recapturar uno nuevo";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  			  
			    var json_request = {
					pTipoOperacion: "cancelarServicio"
					,pNidServicio:pNidServicio
					,pNidEstado:"10"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/catFuncionesFlujoServicio.php",		
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						console.log(resp);
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
					   obtenerServiciosProgramados();
					   //quitar pestaña y panel de la pagina y de tabla
						$("#panelDetalle_" + pNidServicio).remove();
						$("#tabDetalle_" + pNidServicio).remove();
						$("#divTablaServiciosProgramados").collapse("show");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		
		  }
		});
}


//remover de la lista, ¿recargar pagina?, etc? (definir aca que se hace)
function facturarServicio(pNidServicio){
	$("#hfNidServicio").val(pNidServicio);
	var vSistemaPlataforma = 2;
	var vNidEmpresa = 1;
	//$("#popupFacturando").modal("show");
	
	$('#popupFacturando').modal({backdrop: 'static', keyboard: false})  
	
	var json_request = {
		pTipoOperacion: "generarFactura"
		,pNidServicio:pNidServicio
	};
	
	console.log("--> Llama genera factura ");
	console.log(json_request);
    sleepFor(2000);
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catFuncionesFlujoServicio.php",		
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {
			console.log("--> Resultado facturar servicio");
			console.log(resp);			
			$("#txtResultadoFacturacion").val(resp.mensaje);
			//alert("Respuesta facturacion ->" + resp.mensaje);
			console.log("==========[ SE MANDA A TIMBRAR ]===================");
			
			if(parseInt(resp.transaccion) === 1){
			   
				timbrarFactura(vNidEmpresa, vSistemaPlataforma, resp.nid)
			}else{
				ajaxindicatorstop();
				$("#spanResultadoFacturacion").text(" No fue posible facturar");
				$("#spanResultadoFacturacion").css('color',"#FE2E2E");
				
				$("#divResultadoFacturacion").show();
				 $("#divProcesandoFacturacion").hide();	
				 $("#btnSalirFacturacion").show();
			}	
			
		},
		complete: function () {
		  // ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function sleepFor(sleepDuration){
    var now = new Date().getTime();
    while(new Date().getTime() < now + sleepDuration){ 
        /* Do nothing */ 
    }
}

function sleep(ms) {
	return new Promise(resolve => setTimeout(resolve, ms));
  }


function marcarServicioFacturado(pEstadoServicio){
    console.log("--> marcarServicioFacturado");
	var datos = {
		pTipoOperacion: "cambiarEstadoServicio",
		pIdServicio: Number($("#hfNidServicio").val()),
		pEvento: Number(pEstadoServicio)
	};
	
	console.log(datos);
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}


function eliminarFacturaPlataforma(pIdFactura){
	console.log("eliminarFacturaPlataforma, Factua -->" + pIdFactura);
	var datos = {
		pTipoOperacion: "eliminarFactura",
		pTipoSistema: "2",
		pIdFactura: pIdFactura
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log("Resultado eliminarFacturaPlataforma");
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}





