
var $tablaPedimentos;
var $tablaMateriales;
var $tablaPersonal;
var $tablaContenedor;
var $tablaBitacora;
var $tableServiciosProgramados;


$("document").ready(function () {
			
	$("#menuAgenciaProgramados").addClass("subdrop");
	
   	inicialiaValores();		
});



function inicialiaValores(){
	
	consultaXestado();
		
	//Asignamos Tablas a variables
	$tableServiciosProgramados = $("#tablaServiciosProgramados");
	$tablaPedimentos = $("#tablaPedimentos");
	$tablaMateriales = $("#tablaMateriales");
	$tablaPersonal = $("#tablaPersonal");
	$tablaContenedor = $("#tablaContenedor");
	$tablaBitacora = $("#tablaBitacora");

	$("#btnRegresar").click(function(){ verDivGeneral(); });	
	$("#btnImprimir").click(function(){ imprimeServicio(); });
}


function consultaXestado(){
	var json_request = {
		tipoOperacion: "consultaNoTerminados"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosProgramadosAgencia.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
												
			$tableServiciosProgramados.DataTable().clear().draw();			
			$tableServiciosProgramados.dataTable().fnDestroy();
			$tableServiciosProgramados.DataTable({
				data: resp.datos,
				"language": JSON.parse(lenguaje),
				"pageLength": 25,
				columns: [
					{ "data": "codigo" },
					{ "data": "fechaRegistro" },
					{ "data": "tipoCarga" },
					{ "data": "contenedor" },
					{ "data": "cantidad" },
					{ "data": "imo" },
					{ "data": "estado" },
					{ "data": "pedimento" },
					{ "data": "referencia" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalleServicio(" + sData + ")'><i class='fa fa-check-square fa-lg' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function verDetalleServicio(pNidServicio){
	$("#hfNidServicio").val(pNidServicio);
	$("#divGenerales").hide();
	$("#divDetalle").show();
	
	$("#tablaContenedor tbody").empty();
	var json_request = {
		tipoOperacion: "consultarXid"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosProgramadosAgencia.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {  				
				var json = resp.datos[0];	

				$("#spanFolio").text(json.codigo);
				$('#spanAgencia').text(json.cliente);
				$('#spanDependiente').text(json.personalCliente);
				$('#spanTipoCarga').text(json.tipoCarga);
				$('#spanTipoServicio').text(json.tipoServicio);
				$('#spanImportador').text(json.importador);
				$('#spanCantidad').text(json.cantidad);
				$('#spanPatente').text(json.patente);
				$('#spanFiscal').text(json.fiscal);
				$('#spanImo').text(json.imo);
				$('#spanCantidadDesconsolidar').text(json.cantidadDesconsolidar);
				$('#spanCanino').text(json.utilizaCanino);
				$('#spanPeso').text(json.peso);

				$tablaContenedor.append('<tr><td>'+ json.dimencion +'</td><td>'+ json.contenedor +'</td><td>'+ json.selloOriginal +'</td><td>'+ json.selloNuevo +'</td></tr>');				

		},
		complete: function () {
			ajaxindicatorstop();
			consultaPedimentos(pNidServicio);
			consultaMaterial(pNidServicio);
			consultaPersonal(pNidServicio);
			consultaBitacora(pNidServicio);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function consultaPedimentos(pNidServicio){
	$("#tablaPedimentos tbody").empty();
	var json_request = {
		tipoOperacion: "consultarPedimentos"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosProgramadosAgencia.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			if(resp.datos != null){		
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaPedimentos.append('<tr><td>'+ json.pedimento +'</td><td>'+ json.referencia +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaMaterial(pNidServicio){
	$("#tablaMateriales tbody").empty();
	var json_request = {
		tipoOperacion: "consultarMaterial"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosProgramadosAgencia.php",
		dataType: "json",
		async: true,
		success: function (resp) {  								
			if(resp.datos != null){
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaMateriales.append('<tr><td>'+ json.material +'</td><td>'+ json.cantidad +'</td><td>'+ json.unm +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaPersonal(pNidServicio){
	$("#tablaPersonal tbody").empty();
	var json_request = {
		tipoOperacion: "consultarPersonal"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosProgramadosAgencia.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			if(resp.datos != null){		
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaPersonal.append('<tr><td>'+ json.nombre +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaBitacora(pNidServicio){
	$("#tablaBitacora tbody").empty();
	var json_request = {
		tipoOperacion: "consultarBitacora"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosProgramadosAgencia.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			if(resp.datos != null){		
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaBitacora.append('<tr><td>'+ json.descripcion +'</td><td>'+ json.fecha +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function verDivGeneral(){
	$("#divGenerales").show();
	$("#divDetalle").hide();
}

function imprimeServicio(){
	var pNidServicio = $("#hfNidServicio").val();
	var pHtml = reporteServicio(pNidServicio);	
		
	var json_request = {
		tipoOperacion: "servicio",
		pNidServicio:pNidServicio,
		pHtml: pHtml
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/generarPdfs.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);				
		},complete: function () {
			ajaxindicatorstop();
			var urlString = "../sippre/dataAccess/servicios/"+ pNidServicio +".pdf";
			window.open(urlString, '_blank');
			//window.open("data:application/pdf," + encodeURI(urlString)); 
			//$("#iframepdf").attr("src","/moversa/dataAccess/proformas/" + pNidServicio+ ".pdf");
			//$("#popupProforma").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}