
var $tablaPedimentos;
var $tablaMateriales;
var $tablaPersonal;
var $tablaContenedor;
var $tablaBitacora;

var $tableServiciosTerminados;
var $tableServiciosFacturados;

$("document").ready(function () {
			
	$("#linkTerminados").addClass("subdrop");
	
   	inicialiaValores();		
   	
   		$('.select2').select2({
        theme: 'bootstrap4'
    })
});


function inicialiaValores(){
	
	consultaTerminados();
	consultaFacturados();
		
	//Asignamos Tablas a variables
	$tableServiciosTerminados = $("#tablaServiciosTerminados");
	$tableServiciosFacturados = $("#tablaServiciosFacturados");
	
	$tablaPedimentos = $("#tablaPedimentos");
	$tablaMateriales = $("#tablaMateriales");
	$tablaPersonal = $("#tablaPersonal");
	$tablaContenedor = $("#tablaContenedor");
	$tablaBitacora = $("#tablaBitacora");

	$("#btnFiltrar").click(function(){ verFitros(); });	
	$("#btnRegresar").click(function(){ verDivGeneral(); });	
	$("#btnImprimir").click(function(){ imprimeServicio(); });
	$("#btnConsultar").click(function(){ ejecutarConsulta(); });
	$("#btnResetear").click(function(){ resetServicio(); });
	$("#btnFacturar").click(function(){ facturarServicio(); });
	$("#btnGuardarMaterial").click(function(){ guardarMatUsado(); });
	$("#btnActualizaContenedor").click(function(){ actualizaContenedor(); });
	$("#btnActualizarGenerales").click(function(){ actualizarGenerales(); });
	$("#btnGenerarComplemento").click(function(){ generarComplemento(); });
	
	//Iniciamos Fechas
	$('input[id$=txtFechaInicio]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
	
		//Iniciamos Fechas
	$('input[id$=txtFechaFinal]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false		
    });
	
	$('input[id$=txtFechaPago]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
	
	$("#menuAgenciaHistorico").addClass("subdrop");
	
		//cargar personal del cliente seleccionado
	$("#ddlAgencias").on("change", function(e){
		obtenerListadoPersonalCliente($("#ddlAgencias").val());
	});
}


function verFitros(){
	$("#popupFiltros").modal("show");
}


function consultaTerminados(){
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"7"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
										
			$tableServiciosTerminados.DataTable().clear().draw();			
			$tableServiciosTerminados.dataTable().fnDestroy();
			$tableServiciosTerminados.DataTable({
				data: resp.datos,
				"language": JSON.parse(lenguaje),
				"pageLength": 25,
				"order": [[ 0, 'desc' ]],
				columns: [
					//{ "data": "codigo" },
					{
						"data": "codigo",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span> MOV"+ sData +"</span>");
						}
					},
					{ "data": "fechaRegistro" },
					{ "data": "tipoCarga" },
					{ "data": "contenedor" },
					{ "data": "cantidad" },
					{ "data": "imo" },
					//{ "data": "estado" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalleServicio(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function verDetalleServicio(pNidServicio){
	$("#hfNidServicio").val(pNidServicio);
	$("#divGenerales").hide();
	$("#divDetalle").show();
	
	$("#tablaContenedor tbody").empty();
	var json_request = {
		tipoOperacion: "consultarXid"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {  				
				var json = resp.datos[0];	

				$("#spanFolio").text(json.codigo);
				$('#spanAgencia').text(json.cliente);
				$('#spanDependiente').text(json.personalCliente);
				$('#spanTipoCarga').text(json.tipoCarga);
				$('#spanTipoServicio').text(json.tipoServicio);
				$('#spanImportador').text(json.importador);
				$('#spanCantidad').text(json.cantidad);
				$('#spanPatente').text(json.patente);
				$('#spanFiscal').text(json.fiscal);
				$('#spanImo').text(json.imo);
				$('#spanCantidadDesconsolidar').text(json.cantidadDesconsolidar);
				$('#spanCanino').text(json.utilizaCanino);
				$('#spanPeso').text(json.peso);
				
				$('#spanMontoServicio').text("$ " + json.montoServicio);
				$('#spanMontoMaterial').text("$ " +json.montoMaterial);
				$('#spanTotal').text("$ " +json.montoTotal);
				$('#spanFacturar').text(json.clienteFacturar);
				$('#spanObservacionesCarga').text(json.notasCarga);
				$('#spanObservacionesDesc').text(json.obsDesconsol);
				$('#spanObservacionesMuestreo').text(json.observacionesMuestreo);
								
				if(json.tipoCarga === 'CONTENERIZADA'){
					$tablaContenedor.append('<tr><td>'+ json.dimencion +'</td><td>'+ json.contenedor +'</td><td>'+ json.selloOriginal +'</td><td>'+ json.selloNuevo +'</td><td style="text-align: right;padding-right: 25px;"><a href="javascript:verContenedor('+ pNidServicio +')"><i class="fa fa-refresh" aria-hidden="true" style="font-size: 20px;"></i><a></td></tr>');				
					$("#divTablaContenedor").show();
					$("#divEncabezadoContenedor").show();	
				}else{
					$("#divTablaContenedor").hide();
					$("#divEncabezadoContenedor").hide();					
				}
				

		},
		complete: function () {
			ajaxindicatorstop();
			consultaPedimentos(pNidServicio);
			consultaMaterial(pNidServicio);
			consultaPersonal(pNidServicio);
			consultaBitacora(pNidServicio);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function verContenedor(pNidServicio){
	
	var json_request = {
		tipoOperacion: "consultarXid"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		success: function (resp) {  				
				var json = resp.datos[0];	

				console.log(json);

				//$("#ddlTipoContenedor").val(json.dimencion);
				
				$("#ddlTipoContenedor option:contains(" + json.dimencion +")").attr("selected", true);
				
				$("#txtContenedor").val(json.contenedor);
				$("#txtSelloOriginal").val(json.selloOriginal);
				$("#txtSelloNuevo").val(json.selloNuevo);									
				$("#popupContenedor").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
	
	
}

function consultaPedimentos(pNidServicio){
	$("#tablaPedimentos tbody").empty();
	var json_request = {
		tipoOperacion: "consultarPedimentos"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			if(resp.datos != null){		
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaPedimentos.append('<tr><td>'+ json.pedimento +'</td><td>'+ json.referencia +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaMaterial(pNidServicio){
	$("#tablaMateriales tbody").empty();
	var json_request = {
		tipoOperacion: "consultarMaterial"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		success: function (resp) {  								

            console.log("-> Lista materiales");
            console.log(resp);
			if(resp.datos != null){
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaMateriales.append('<tr><td>'+ json.material +'</td><td>'+ json.cantidad +'</td><td>'+ json.unm +'</td><td style="text-align: right;"><a href="javascript:quitarMaterial('+ json.nid +')"><i class="fa fa-trash" aria-hidden="true" style="font-size: 20px;padding-right: 25px;"></i></a></td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaPersonal(pNidServicio){
	$("#tablaPersonal tbody").empty();
	var json_request = {
		tipoOperacion: "consultarPersonal"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			if(resp.datos != null){		
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaPersonal.append('<tr><td>'+ json.nombre +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaBitacora(pNidServicio){
	$("#tablaBitacora tbody").empty();
	var json_request = {
		tipoOperacion: "consultarBitacora"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			if(resp.datos != null){		
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];				
					$tablaBitacora.append('<tr><td>'+ json.descripcion +'</td><td>'+ json.fecha +'</td></tr>');
				}
			}									
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function verDivGeneral(){
	$("#divGenerales").show();
	$("#divDetalle").hide();
}

function imprimeServicio(){
	var pNidServicio = $("#hfNidServicio").val();
	var pHtml = reporteServicio(pNidServicio);	
		
	var json_request = {
		tipoOperacion: "servicio",
		pNidServicio:pNidServicio,
		pHtml: pHtml
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../sippre/dataAccess/generarPdfs.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);				
		},complete: function () {
			ajaxindicatorstop();
			var urlString = "../sippre/dataAccess/servicios/"+ pNidServicio +".pdf";
			window.open(urlString, '_blank');
			//window.open("data:application/pdf," + encodeURI(urlString)); 
			//$("#iframepdf").attr("src","/moversa/dataAccess/proformas/" + pNidServicio+ ".pdf");
			//$("#popupProforma").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}


function ejecutarConsulta(){
	$("#popupFiltros").modal("hide");
}

function resetServicio(){
	var pNidServicio = $("#hfNidServicio").val();
	
	
	var mensaje = "El servicio será regresado al estado de 'Programado', los datos capturados serán borrados.";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "resetear"
					,pNidServicio:pNidServicio
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/serviciosTerminados.php",		
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultaXestado();
						verDivGeneral();
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		
		  }
		});
}

function consultaFacturados(){
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"8"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
										
			$tableServiciosFacturados.DataTable().clear().draw();			
			$tableServiciosFacturados.dataTable().fnDestroy();
			$tableServiciosFacturados.DataTable({
				data: resp.datos,
				"language": JSON.parse(lenguaje),
				"pageLength": 25,
				"order": [[ 0, 'desc' ]],
				 autoWidth: false,
				columns: [
					//{ "data": "codigo" },
					{
						"data": "codigo",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span> MOV"+ sData +"</span>");
						}
					},
					{ "data": "nidFactura" },
					{ "data": "fechaRegistro" },
					{ "data": "tipoCarga" },
					{ "data": "contenedor" },
					{ "data": "cantidad","width": "5%"},
					{ "data": "imo","width": "5%"},
					//{ "data": "estado" },
					{
						"data": "nid",
						"width": "10%",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vNidFactura = "'" + oData.nidFactura + "'";
							var vUuid = "'" + oData.uuid + "'";
							var vIdCliente = "'" + oData.nidCliente + "'";
							$(nTd).html('<span><a href="#" class="btn btn-danger btn-sm" style="font-size: 12px;" onclick="ventanaComplementoPago(' + sData + ','+ vNidFactura +','+ vUuid +','+ vIdCliente +')">Complemento</a></span>');
						}
					}
				]
			});					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function actualizaContenedor(){
	var pNidServicio = $("#hfNidServicio").val();
	
	var pTipoContenedor = $("#ddlTipoContenedor").val();
	var pContenedor = $("#txtContenedor").val();
	var pSelloOriginal = $("#txtSelloOriginal").val();
	var pSelloNuevo = $("#txtSelloNuevo").val();	
	
	var json_request = {
		tipoOperacion: "actualizaContenedor"            
		,pNidServicio:pNidServicio
		,pTipoContenedor:pTipoContenedor
		,pContenedor:pContenedor
		,pSelloOriginal:pSelloOriginal
		,pSelloNuevo:pSelloNuevo
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) { 
			console.log(resp);
			MessageBox(resp.transaccion, resp.mensaje);	

		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupContenedor").modal("hide");
			verDetalleServicio(pNidServicio);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
	
}

function agregarMaterial(){
	cargarMateriales();
	$("#txtCantidad").val("");
	$("#popupMaterial").modal("show");
}

function cargarMateriales(){
	 $("#ddlMaterial").empty();
	 
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catMateriales.php",
		dataType: "json",
		async: true,
		success: function (resp) {	
            for (var i = 0; i < resp.datos.length; i++) {
                var json = resp.datos[i];
                $("#ddlMaterial").append('<option value="' + json.nid + '">' + json.nombre + '</option>');                
            }				
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function guardarMatUsado(){

	var pNidServicio = $("#hfNidServicio").val();
	var pNidMaterial = $("#ddlMaterial").val();
	var pCantidad = $("#txtCantidad").val();
	
	var datos = {
		pTipoOperacion: "guardarMatUsado",
		pIdServicio: pNidServicio,
		pIdMaterial: pNidMaterial,
		pCantidad: pCantidad,
		pIndice: 1
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},		
		success: function (resp) { 
			console.log(resp);
			if (parseInt(resp.transaccion) === 1){
				swal("Correcto",resp.mensaje,"success");
				recalculaTarifas();
				consultaMaterial(pNidServicio);
				$("#popupMaterial").modal("hide");
			} else {
				swal("Error","No se pudo guardar el material usado:" + resp.mensaje,"error");
			}
				
		},
		complete: function () {
			//detener indicador de carga
			
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function quitarMaterial(pNidMaterial){
	var pNidServicio = $("#hfNidServicio").val();
	
	var mensaje = "Se eliminará el material del servicio.";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminarMaterialServicio"
					,pNidServicio:pNidServicio
					,pNidMaterial:pNidMaterial
				};
							  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "/sippre/dataAccess/serviciosTerminados.php",		
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						console.log(resp);
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
						consultaMaterial($("#hfNidServicio").val());
						recalculaTarifas();
		               ajaxindicatorstop();
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		
		  }
		});
}

function ventanaActualizaGenerales(){
	obtenerListadoClientes();

	$("#ddlDependientes").empty();
	$("#popupGenerales").modal("show");
}


function obtenerListadoClientes(){
	var datos = {
		pTipoOperacion: "obtenerListadoClientes"
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesProgramarServicios.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			 var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de empresas
			if (resp.transaccion > 0){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].patente +" - " + resp.datos[i].nombre + " </option>";
				}
				$("#ddlAgencias").empty();
				$("#ddlAgencias").append(strtmp);
			}
				
		},
		complete: function () {
			//detener indicador de carga
			$('#ddlAgencias').selectpicker('refresh');
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});	
}

function obtenerListadoPersonalCliente(idCliente){
	var datos = {
		pTipoOperacion: "obtenerListadoPersonalCliente",
		pIdCliente: Number(idCliente),
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesProgramarServicios.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//indicador de carga
		},
		success: function (resp) { 
			var strtmp = "<option value='-1' selected> Seleccione una opción </option>";
			//Recorremos lista de personal del cliente especificado
			if (resp.transaccion > 0 && (resp.datos != null) ){
				for (var i = 0; i < resp.datos.length; i++) {
					strtmp += "<option value='" + resp.datos[i].id + "'> " + resp.datos[i].nombre + " </option>";
				}
				$("#ddlDependientes").empty();
				$("#ddlDependientes").append(strtmp);
			} else {
				strtmp = "<option value='-1' selected> No se encontró personal para la empresa seleccionada </option>";
				$("#ddlDependientes").empty();
				$("#ddlDependientes").append(strtmp);
			}
				
		},
		complete: function () {
			
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function actualizarGenerales(){
	var pNidServicio = $("#hfNidServicio").val();
	var pNidCliente = $("#ddlAgencias").val();
	var pNidPersonal = $("#ddlDependientes").val();
	
	var datos = {
		tipoOperacion: "actualizaGenerales",
		pNidServicio: pNidServicio,
		pNidCliente: pNidCliente,
		pNidPersonal: pNidPersonal
	};

	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},		
		success: function (resp) { 
			console.log(resp);
			if (parseInt(resp.transaccion) === 1){
				swal("Correcto",resp.mensaje,"success");
			} else {
				swal("Error","Error en la transaccion:" + resp.mensaje,"error");
			}			
		},
		complete: function () {
			//detener indicador de carga
			$("#popupGenerales").modal("hide");
			verDetalleServicio(pNidServicio);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function recalculaTarifas(){
	var pNidServicio = $("#hfNidServicio").val();
	var pClienteFacturar = $("#spanFacturar").text();
	
	var datos = {
		tipoOperacion: "recalculaTarifas",
		pNidServicio: pNidServicio,
		pClienteFacturar: pClienteFacturar
	};

	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			//indicador de carga
		},		
		success: function (resp) { 
			console.log("====[ Respuesta recalcular tarifa ]======");
			console.log(resp);
				
		},
		complete: function () {
			verDetalleServicio(pNidServicio);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function ventanaComplementoPago(pNidServicio,pNidFactura, pUuid, pNidCliente){
	$("#hfNidServicio").val(pNidServicio);
	$("#hfNidCliente").val(pNidCliente);
	$("#hfNidFactura").val(pNidFactura);
	$("#hfUuid").val(pUuid);
	
	consultarFormasPago();
	$("#popupDatosComplementoPago").modal("show");
}

function consultarFormasPago(){
    $("#ddlFormasPago").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catFormasPago.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlFormasPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlFormasPago").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function generarComplemento(){
	var vGeneroComplemento = true;

	var pNidCliente = $("#hfNidCliente").val();
	var pMonto = $("#txtMonto").val();
	var pFechaPago = $("#txtFechaPago").val();
	var pNumOperacion = $("#txtNumOperacion").val();
	var pBancoOrdentante = $("#txtBancoOrdenante").val();
	var pFormasPago = $("#ddlFormasPago").val();
	var pRfcOrdenante = $("#txtRfcOrdenante").val();
	var pCuentaOrdenante = $("#txtCuentaOrdenante").val();
	var pRfcBeneficiario = $("#txtRfcBeneficiario").val();
	var pCuentaBeneficiario = $("#txtCuentaBeneficiario").val();
	
	var vNidComplementoPago = 0;
	
	if(validaDatosComplemento()){
	
		ajaxindicatorstart();
		$("#divGeneralPago").hide();
		$("#divGenerandoPago").show();
		$("#divFooter").hide();
		
		
			var json_request = {
				tipoOperacion: "complementoPagoInsertar" 
				,pNidCliente:pNidCliente
				,pMonto:pMonto
				,pFechaPago:pFechaPago
				,pNumOperacion:pNumOperacion
				,pBancoOrdentante:pBancoOrdentante
				,pFormasPago:pFormasPago
				,pRfcOrdenante:pRfcOrdenante
				,pCuentaOrdenante:pCuentaOrdenante
				,pRfcBeneficiario:pRfcBeneficiario
				,pCuentaBeneficiario:pCuentaBeneficiario
			};	
			
			console.log("Parametros complementoPagoInsertar");
			console.log(json_request);
			
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../sippre/dataAccess/serviciosTerminados.php",
				dataType: "json",
				async: true,
				beforeSend: function () {
					//ajaxindicatorstart();
				},
				success: function (resp) {             

					console.log(resp);
					
					if(parseInt(resp.transaccion) === 1){
					
								var pNidFactura = $("#hfNidFactura").val();
								var pUuid = $("#hfUuid").val();
								vNidComplementoPago = resp.nid;

								var json_request = {
									tipoOperacion: "complementoPagoInsertarDetalle" 
									,pNidComplemento:resp.nid
									,pNidFactura:pNidFactura
									,pUuid:pUuid
								};		
								
								console.log(json_request);
								
								$.ajax({
									type: "POST",
									data: json_request,
									url: "../sippre/dataAccess/serviciosTerminados.php",
									dataType: "json",
									async: true,
									beforeSend: function () {
										//ajaxindicatorstart();
									},
									success: function (resp) {             
										console.log(resp);

										if(parseInt(resp.transaccion) === 0){
											vGeneroComplemento = false;
										}

									},
									complete: function () {
										//ajaxindicatorstop();						
									},
									error: function (xhr, ajaxOptions, thrownError) {
										console.log(xhr);
										console.log(ajaxOptions);
										console.log(thrownError);
									}
								});

						if(vGeneroComplemento){
							timbrarComplemento(1,2,resp.nid);
						}else{
							MessageBox(0, "ERROR AL GENERAR COMPLEMENTO, NO SE PUEDE TIMBRAR");
							//Eliminamos el encabezado del complemento de pago
							eliminarComplemento(vNidComplementoPago);
						}
					}
					else{
						MessageBox(resp.transaccion, resp.mensaje);
					}
				},
				complete: function () {
					//ajaxindicatorstop();
					$("#popupModificar").modal("hide");
					//consultar();

					 //verDetalleServicio($("#hfNidServicio").val(), $("#spanBuqueProforma").text(), 0, 2);							
				},
				error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);
				}
			});
	}
}

function validaDatosComplemento(){
	var respuesta=true;
    var mensaje="";
	
	var pMonto = $("#txtMonto").val();
	var pFechaPago = $("#txtFechaPago").val();
	var pNumOperacion = $("#txtNumOperacion").val();
	var pBancoOrdentante = $("#txtBancoOrdenante").val();
	var pFormasPago = $("#ddlFormasPago").val();
	var pRfcOrdenante = $("#txtRfcOrdenante").val();
	var pCuentaOrdenante = $("#txtCuentaOrdenante").val();
	var pRfcBeneficiario = $("#txtRfcBeneficiario").val();
	var pCuentaBeneficiario = $("#txtCuentaBeneficiario").val();

	if(pRfcBeneficiario.length === 0){
        if(pCuentaBeneficiario.length > 0){
			$("#txtRfcBeneficiario").addClass('campo-requerido');
			respuesta=false;
		}
    }else{
		if(pCuentaBeneficiario.length === 0){
			$("#txtCuentaBeneficiario").addClass('campo-requerido');
			respuesta=false;
		}else{
			var tamCuenta= pCuentaBeneficiario.length;

			if(tamCuenta != 10 && tamCuenta != 16 && tamCuenta != 18){
				$("#txtCuentaBeneficiario").addClass('campo-requerido');
				respuesta=false;
			}
		}
	}


	if(pRfcOrdenante.length === 0){
        if(pCuentaOrdenante.length > 0){
			$("#txtRfcOrdenante").addClass('campo-requerido');
			respuesta=false;
		}
    }else{
		if(pCuentaOrdenante.length === 0){
			$("#txtCuentaOrdenante").addClass('campo-requerido');
			respuesta=false;
		}else{
			var tamCuenta= pCuentaOrdenante.length;

			if(tamCuenta != 10 && tamCuenta != 16 && tamCuenta != 18){
				$("#txtCuentaOrdenante").addClass('campo-requerido');
				respuesta=false;
			}
		}
	}

	if(pNumOperacion.length === 0){
        $("#txtNumOperacion").addClass('campo-requerido');
        respuesta=false;
    }

	/*if(pBancoOrdentante.length === 0){
        $("#txtBancoOrdenante").addClass('campo-requerido');
        respuesta=false;
    }*/

	if(parseInt(pFormasPago) === -1 ){
        $("#ddlFormasPago").addClass('campo-requerido');
        respuesta=false;
    }	
	
	if(pMonto.length === 0){
        $("#txtMonto").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pFechaPago.length === 0){
        $("#txtFechaPago").addClass('campo-requerido');
        respuesta=false;
    }
		
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar o el campo no cumple con los requerimientos", "error");
    }
    
    return respuesta;
}

function limpiarCamposComplementos(){
	$("#txtMonto").val("");
	$("#txtFechaPago").val("");
	$("#txtNumOperacion").val("");
	$("#txtBancoOrdenante").val("");
	$("#ddlFormasPago").val("-1");
	$("#txtRfcOrdenante").val("");
	$("#txtCuentaOrdenante").val("");
	$("#txtRfcBeneficiario").val("");
	$("#txtCuentaBeneficiario").val("");
}

function marcarServicioFacturado(pEstadoServicio){

	var datos = {
		pTipoOperacion: "cambiarEstadoServicio",
		pIdServicio: Number($("#hfNidServicio").val()),
		pEvento: Number(pEstadoServicio)
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}


async function facturarServicio(){

	var pNidServicio = $("#hfNidServicio").val();
	var vSistemaPlataforma = 2;
	var vNidEmpresa = 1;
		
	$("#spanResultadoFacturacion").text("");
	$('#popupFacturando').modal({backdrop: 'static', keyboard: false})  
	

	var json_request = {
		pTipoOperacion: "generarFactura"
		,pNidServicio:pNidServicio
	};

	$.ajax({
		type: "POST",
		data: json_request,
		url: "/sippre/dataAccess/catFuncionesFlujoServicio.php",		
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {
			console.log("--> Resultado facturar servicio");
			console.log(resp);			
			
			
						
			if(parseInt(resp.transaccion) === 1){
				console.log("==========[ SE MANDA A TIMBRAR ]===================");
				timbrarFactura(vNidEmpresa, vSistemaPlataforma, resp.nid)
			}else{
				console.log("==========[ NO SE MANDA A TIMBRAR, SERVICIO NO CUMPLE CON LOS REQUISITOS ]===================");
				ajaxindicatorstop();
				$("#spanResultadoFacturacion").text(" No fue posible facturar");
				$("#spanResultadoFacturacion").css('color',"#FE2E2E");
				$("#txtResultadoFacturacion").val(resp.mensaje);
				$("#divProcesandoFacturacion").hide();
				$("#divResultadoFacturacion").show();
					
				$("#btnSalirFacturacion").show();
								 
				//*** MANDAR LLAMAR METODO PARA ELIMINAR FACTURA
				//eliminarFactura();
			}	
			
		},
		complete: function () {
		  // ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function eliminarComplemento(pIdFolioComp){

	var datos = {
		pTipoOperacion: "eliminarComplemento",
		pTipoSistema: "2",
		pIdFolioComp: pIdFolioComp
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function eliminarFacturaPlataforma(pIdFactura){
	console.log("eliminarFacturaPlataforma, Factua -->" + pIdFactura);
	var datos = {
		pTipoOperacion: "eliminarFactura",
		pTipoSistema: "2",
		pIdFactura: pIdFactura
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../sippre/dataAccess/catFuncionesFlujoServicio.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log("Resultado eliminarFacturaPlataforma");
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}