<?php

/*
  Created on : Nov 01, 2019, 09:32:55 PM
  Author     : Alberto Nery
 */
 
	if(!isset($_SESSION)) session_start();
	require_once "../core/core_classes.php";
	require_once "../core/core_classes_servicio.php";
	require_once "../core/core_messages.php";
	require_once "../config.php";

	$user = json_decode($_SESSION['user']);
	$idEmpresa = $user->nidEmpresa;
	$idCliente = $user->nidCliente;

	switch (filter_input(INPUT_POST, 'pTipoOperacion')) {

		case 'obtenerTiposServicio':
			//ejecutar
			$stmt = $conn->prepare("call tipos_servicio_consulta()");
			$stmt->execute();			
			
			//obtener dataset 
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_tiposervicio();
				$respuesta->id = $row['Id'];
				$respuesta->nomtiposervicio = $row['NomTipoServicio'];
				$response->datos[] = $respuesta;
				// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
				// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
				// }
			}
			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'obtenerCantidadRetirar':

			//ejecutar
			$stmt = $conn->prepare("call desconsolidacion_medida_consulta()");
			$stmt->execute();			
			
			//obtener dataset 
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_desconsol_medida();
				$respuesta->id = $row['Id'];
				$respuesta->medida = $row['Medida'];
				$response->datos[] = $respuesta;

			}
			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'obtenerPersonalEmpresa':
			//$idEmpresa = 1;

			//ejecutar
			$stmt = $conn->prepare("call empleados_consulta($idEmpresa)");
			$stmt->execute();	

			//obtener dataset 
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_personal_empresa();
				$respuesta->id = $row['Id'];
				$respuesta->nombreempleado = $row['NombreEmpleado'];
				$respuesta->credencial = $row['Credencial'];
				$response->datos[] = $respuesta;
			}

			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'obtenerVistasFiscales':
			$idEmpresa = 1;

			//ejecutar
			$stmt = $conn->prepare("call aduana_personal_consulta($idEmpresa)");
			$stmt->execute();	

			//obtener dataset 
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_aduana_personal();
				$respuesta->id = $row['Id'];
				$respuesta->nombre = $row['Nombre'];
				$response->datos[] = $respuesta;
			}

			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'obtenerTipoDanosContenedor':
			$idEmpresa = 1;

			//ejecutar
			$stmt = $conn->prepare("call contenedor_danos_consulta($idEmpresa)");
			$stmt->execute();	

			//obtener dataset 
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_contenedor_danos();
				$respuesta->id = $row['Id'];
				$respuesta->nomdano = $row['NomDano'];
				$response->datos[] = $respuesta;
			}

			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		

		case 'obtenerMaterialesServicio':
		    $idClienteServicio = (int)filter_input(INPUT_POST, 'pIdCliente');
			
			//$stmt = $conn->prepare("call materiales_consulta($idEmpresa,$idClienteServicio)");
			$stmt = $conn->prepare("call materiales_consulta($idEmpresa)");
			$stmt->execute();	

			//obtener dataset 
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_materiales_servicio();
				$respuesta->id = $row['Id'];
				$respuesta->idempresa = $row['IdEmpresa'];
				$respuesta->nombrematerial = $row['NombreMaterial'];
				$respuesta->unidad = $row['Unidad'];
				$respuesta->descunidad = $row['DescUnidad'];
				$respuesta->costo = $row['Costo'];
				$response->datos[] = $respuesta;
			}

			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'obtenerServiciosProgramados':
			//$idEmpresa = 1;

			$response = new root_response;
			//$servicios = [];
			for ($x = 1; $x < 7 ; $x++) {
				//call procedimiento
				$stmt = $conn->prepare("call servicios_consultasxEstado($idEmpresa, $x)");
				$stmt->execute();

				$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
				foreach ( $rows as $row ){
					$respuesta = new core_servicio_x_estado();
					$respuesta->idservicio = $row['IdServicio'];
					$respuesta->idempresa = $row['IdEmpresa'];
					$respuesta->codigotrazabilidad = $row['IdServicio'];
					$respuesta->importador = $row['Importador'];
					$respuesta->idcliente = $row['IdCliente'];
					$respuesta->nomcliente = $row['NomCliente'];
					$respuesta->idclipersonal = $row['IdCliPersonal'];
					$respuesta->idtipocarga = $row['IdTipoCarga'];
					$respuesta->nomtipocarga = $row['NomTipoCarga'];
					$respuesta->imo = $row['imo'];
					$respuesta->descimo = $row['DESCIMO'];
					$respuesta->iddimcon = $row['IdDimCon'];
					$respuesta->nomdimension = $row['NomDimension'];
					$respuesta->contenedor = $row['Contenedor'];
					$respuesta->sellooriginal = $row['SelloOriginal'];
					$respuesta->sellonuevo = $row['SelloNuevo'];
					$respuesta->cantidad = $row['Cantidad'];
					$respuesta->peso = $row['Peso'];
					$respuesta->idtiposervicio = $row['IdTipoServicio'];
					$respuesta->nomtiposervicio = $row['NomTipoServicio'];
					$respuesta->iddesmed = $row['IdDesMEd'];
					$respuesta->nomdesmedida = $row['NomDesMedida'];
					$respuesta->notascantidad = $row['notasCantidad'];
					$respuesta->utilizacanino = $row['UtilizaCanino'];
					$respuesta->usacanino = $row['USACANINO'];
					$respuesta->notascarga = $row['notasCarga'];
					$respuesta->revisionnointrusiva = $row['RevisionNoIntrusiva'];
					$respuesta->usarevintrusiva = $row['USAREVINTRUSA'];
					$respuesta->muestreomercancia = $row['MuestreoMercancia'];
					$respuesta->usamuestreo = $row['USAMUESTREO'];
					$respuesta->observacionesmuestreo = $row['ObservacionesMuestreo'];
					$respuesta->clientefacturar = $row['ClienteFacturar'];
					$respuesta->montomaterial = $row['MontoMaterial'];
					$respuesta->montototal = $row['MontoTotal'];
					$respuesta->fechacaptura = $row['FechaCaptura'];
					$respuesta->idusuario = $row['IdUsuario'];
					$respuesta->idestado = $row['IdEstado'];
					$respuesta->descestado = $row['DESCESTADO'];
					$response->datos[] = $respuesta;
					//array_push($servicios, $respuesta);
				}
			}
			//$response->datos[] = $respuesta;
			//$response->datos[] = $servicios;
			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;
			
		case 'cambiarEstadoServicio':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pEvento = (int)filter_input(INPUT_POST, 'pEvento');

			//ejecutar
			$stmt = $conn->prepare("call servicios_eventos_insertar($idEmpresa, $pIdServicio, $pEvento, '')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			//TODO: ENVIAR LA NOTIFICACION

			echo json_encode($response);
			break;

		case 'guardarLadoEIR':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pLado = (int)filter_input(INPUT_POST, 'pLado');
			$pObs = "";

			if ($pLado == 1){
				//eliminarEIRPrevioServicio($idEmpresa, $pIdServicio);
				$stmt = $conn->prepare("call servicios_eyr_eliminar($idEmpresa, $pIdServicio)");
				$stmt->execute();
				//respuesta
				$row = $stmt->fetch(PDO::FETCH_ASSOC);
				$respuestaBorradoEIR = $row['Transaccion'];
			}

			if ($pLado == 7) {
				//observaciones EIR
				$pStatus = 1;
				$pObs = filter_input(INPUT_POST, 'pStatus');
			} else {
				//lados EIR
				$pStatus = (int)filter_input(INPUT_POST, 'pStatus');
				$pObs = "";
			}
			//$pStatus = (int)filter_input(INPUT_POST, 'pStatus');

			//ejecutar
			$stmt = $conn->prepare("call servicios_eyr_insertar($idEmpresa, $pIdServicio, $pLado, $pStatus, '$pObs')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarSelloOriginal':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pSelloOriginal = filter_input(INPUT_POST, 'pSelloOriginal');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_SelloOriginal($idEmpresa, $pIdServicio, '$pSelloOriginal')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarSelloNuevo':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pSelloNuevo = filter_input(INPUT_POST, 'pSelloOriginal');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_SelloNuevo($idEmpresa, $pIdServicio, '$pSelloNuevo')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarTipoServicio':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pTipoServicio = (int)filter_input(INPUT_POST, 'pTipoServicio');
			$pRevisionNoIntrusiva = (int)filter_input(INPUT_POST, 'pRevisionNoIntrusiva');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_TipoServicio($idEmpresa, $pIdServicio, $pTipoServicio, $pRevisionNoIntrusiva)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarCantidadRetirar':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pIdDesMed = (int)filter_input(INPUT_POST, 'pIdDesMed');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_CantidadARetirar($idEmpresa, $pIdServicio, $pIdDesMed)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;
			
		case 'guardarObsDesconsolidacion':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pObsDesconsol = filter_input(INPUT_POST, 'pObsDesconsol');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_obsDesconsol($idEmpresa, $pIdServicio, '$pObsDesconsol')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarVistaFiscal':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pIdPersonalAduana = (int)filter_input(INPUT_POST, 'pIdPersonalAduana');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_FiscalAduana($idEmpresa, $pIdServicio, $pIdPersonalAduana)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarPersonalMoversaServicio':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pIdPersonal = (int)filter_input(INPUT_POST, 'pIdPersonal');
			$pIndice = (int)filter_input(INPUT_POST, 'pIndice');

			if ($pIndice == 0){
				$stmt = $conn->prepare("call servicios_personal_moversa_eliminar($idEmpresa, $pIdServicio)");
				$stmt->execute();
				//respuesta
				$row = $stmt->fetch(PDO::FETCH_ASSOC);
				$respuestaBorradoEIR = $row['Transaccion'];
			}

			//ejecutar
			$stmt = $conn->prepare("call servicios_personal_moversa_insertar($idEmpresa, $pIdServicio, $pIdPersonal)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;
		
		case 'guardarEdoMcia':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pEdoMcia = filter_input(INPUT_POST, 'pEdoMcia');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_NotasCarga($idEmpresa, $pIdServicio, '$pEdoMcia')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarBinomioCanino':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pUsaCanino = (int)filter_input(INPUT_POST, 'pUsaCanino');
			$pUsaMuestreo = (int)filter_input(INPUT_POST, 'pUsaMuestreo');
			$pObsMuestreo = filter_input(INPUT_POST, 'pObsMuestreo');

			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_BinomioCanino($idEmpresa, $pIdServicio, $pUsaCanino, $pUsaMuestreo, '$pObsMuestreo')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarClienteFacturar':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pClienteFacturar = filter_input(INPUT_POST, 'pClienteFacturar');

			//ejecutar
			$stmt = $conn->prepare("call servicios_calculo_tarifas($idEmpresa, $pIdServicio, '$pClienteFacturar')");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'guardarMatUsado':
			//$idEmpresa = 1;
			$pIdServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$pIdMaterial = (int)filter_input(INPUT_POST, 'pIdMaterial');
			$pCantidad = (float)filter_input(INPUT_POST, 'pCantidad');
			$pIndice = (int)filter_input(INPUT_POST, 'pIndice');

			if ($pIndice == 0){
				$stmt = $conn->prepare("call servicios_material_eliminar($idEmpresa, $pIdServicio)");
				$stmt->execute();
				//respuesta
				$row = $stmt->fetch(PDO::FETCH_ASSOC);
				$respuestaBorradoEIR = $row['Transaccion'];
			}

			//ejecutar
			$stmt = $conn->prepare("call servicios_material_insertar($idEmpresa, $pIdServicio, $pIdMaterial, $pCantidad)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'obtenerEventosServicio':

			$idServicio = (int)filter_input(INPUT_POST, 'pIdServicio');
			$response = new root_response;

			//call procedimiento
			$stmt = $conn->prepare("call servicios_eventos_consulta($idEmpresa, $idServicio)");
			$stmt->execute();

			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_eventos_servicio_timer();
				$respuesta->idserevento = $row['IdSerEvento'];
				$respuesta->idservicio = $row['IdServicio'];
				$respuesta->idempresa = $row['IdEmpresa'];
				$respuesta->idevento = $row['IdEvento'];
				$respuesta->nomtipoevento = $row['NomTipoEvento'];
				
				$horafecha = strtotime($row['Fecha_Hora']);
				$fechaString = date("d/m/Y H:i:s", $horafecha);
				$respuesta->fechahora = $fechaString;
				//$respuesta->fechahora = $row['fechahora'];
				$respuesta->notas = $row['notas'];
				$response->datos[] = $respuesta;
			}

			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;
			
		case 'generaCrobro':
			
			$pNidServicio = (int)filter_input(INPUT_POST, 'pNidServicio');
						
			//ejecutar
			$stmt = $conn->prepare("call servicios_genera_cobros_moversa($idEmpresa, $pNidServicio)");
			//$stmt = $conn->prepare("call servicios_genera_cobros($idEmpresa, $pNidServicio)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;	
		case 'cancelarServicio':
			
			$pNidServicio = (int)filter_input(INPUT_POST, 'pNidServicio');
			$pNidEstado = (int)filter_input(INPUT_POST, 'pNidEstado');
						
			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_Estado($idEmpresa, $pNidServicio,$pNidEstado)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
		break;	
			
		case 'generarFactura':
			$pNidServicio = (int)filter_input(INPUT_POST, 'pNidServicio');
						
			//ejecutar
			$stmt = $conn->prepare("call validaFactura($pNidServicio)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];
			$response->nid = $row['NidProforma'];

			echo json_encode($response);
			break;	
			
		case 'eliminarFactura':
			
			$pTipoSistema = (int)filter_input(INPUT_POST, 'pTipoSistema');
			$pIdFactura = (int)filter_input(INPUT_POST, 'pIdFactura');
						
			//ejecutar
			$stmt = $conn->prepare("call setivera_facturacion.facturas_eliminar($idEmpresa, $pTipoSistema,$pIdFactura)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;	
		case 'eliminarComplemento':
			
			$pTipoSistema = (int)filter_input(INPUT_POST, 'pTipoSistema');
			$pIdFolioComp = (int)filter_input(INPUT_POST, 'pIdFolioComp');
						
			//ejecutar
			$stmt = $conn->prepare("call servicios_actualizar_Estado($idEmpresa, $pTipoSistema,$pIdFolioComp)");
			$stmt->execute();

			//respuesta
			$response = new root_response;

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$response->transaccion = $row['Transaccion'];
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;				
		default:
			$response = new root_response;
			$response->transaccion = 0;
			$response->mensaje = "Funcion no reconocida";
			$response->datos = "";
			
			echo json_encode($response);
			break;
	}
        
?>
