<?php	
	if(!isset($_SESSION)) session_start();
	require_once "../core/core_classes.php";
	require_once "../core/core_classes_programacion.php";
	require_once "../core/core_messages.php";
	require_once "../config.php";
	
	$user = json_decode($_SESSION['user']);
	$idEmpresa = $user->nidEmpresa;

	switch (filter_input(INPUT_POST, 'pTipoOperacion')) {

		case 'obtenerListadoClientes':

			$stmt = $conn->prepare("call clientes_consulta('$idEmpresa')");
			$stmt->execute();			
			
			//$numRegistros = $stmt->rowCount();
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC); //Si solo regresa un row la consulta
			foreach ( $rows as $row ){
				$respuesta = new core_clientes();
				$respuesta->id = $row['Id'];
				$respuesta->nombre = $row['Nombre'];
				$respuesta->patente = $row['Patente'];
				$response->datos[] = $respuesta;
				// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
				// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
				// }
			}
			$response->transaccion = "1";
			$response->mensaje = "OK";

			echo json_encode($response);
			break;
			
		case 'obtenerImportadores':
		    
		    $pTexto = filter_input(INPUT_POST, 'pTexto');
		    
			$stmt = $conn->prepare("call importadores_consulta('$idEmpresa', '$pTexto')");
			$stmt->execute();
			
			//$numRegistros = $stmt->rowCount();
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$tmplistado = [];
			foreach ( $rows as $row ){
				$respuesta = new core_importadores();
				$respuesta->importador = $row['importador'];
				$response->datos[] = $respuesta;
				array_push($tmplistado, $row['importador']);
				
				// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
				// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
				// }
			}
			
			file_put_contents("../assets/js/test-list.json", json_encode($tmplistado));
			$response->transaccion = "1";
			$response->mensaje = "OK";

			echo json_encode($response);
			break;

		case 'obtenerListadoPersonalCliente':
			$idCliente = (int)filter_input(INPUT_POST, 'pIdCliente');
			
			$stmt = $conn->prepare("call clientes_personal_consulta('$idEmpresa','$idCliente')");
			$stmt->execute();			
			
			//$numRegistros = $stmt->rowCount();
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC); //Si solo regresa un row la consulta
			foreach ( $rows as $row ){
				$respuesta = new core_clientes_personal();
				$respuesta->id = $row['Id'];
				$respuesta->idcliente = $row['IdCliente'];
				$respuesta->nomcliente = $row['NomCliente'];
				$respuesta->nombre = $row['Nombre'];
				$response->datos[] = $respuesta;
				// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
				// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
				// }
			}
			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'obtenerTiposCarga':
			$stmt = $conn->prepare("call tipos_carga_consulta()");
			$stmt->execute();			
			
			$response = new root_response;
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ( $rows as $row ){
				$respuesta = new core_tipo_carga();
				$respuesta->id = $row['Id'];
				$respuesta->nomtipocarga = $row['NomTipoCarga'];
				$response->datos[] = $respuesta;
				// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
				// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
				// }
			}
			$response->transaccion = "1";
			$response->mensaje = "OK";	

			echo json_encode($response);
			break;

		case 'serviciosInsertar':
			$pIdUsuario = 1;
			//$pCodigoTrazabilidad = filter_input(INPUT_POST, 'pCodigoTrazabilidad');
			$pIdCliente = (int)filter_input(INPUT_POST, 'pIdCliente');
			$pIdCliPersonal = (int)filter_input(INPUT_POST, 'pIdCliPersonal');
			$pImportador = filter_input(INPUT_POST, 'pImportador');
			$pIdTipoCarga = (int)filter_input(INPUT_POST, 'pIdTipoCarga');
			$pimo = (int)filter_input(INPUT_POST, 'pimo');
			$pIdDimCon = (int)filter_input(INPUT_POST, 'pIdDimCon');
			$pContenedor = filter_input(INPUT_POST, 'pContenedor');
			$pSelloOriginal = filter_input(INPUT_POST, 'pSelloOriginal');
			$pSelloNuevo = filter_input(INPUT_POST, 'pSelloNuevo');
			$pCantidad = filter_input(INPUT_POST, 'pCantidad');
			$pPeso = filter_input(INPUT_POST, 'pPeso');
			$pIdTipoServicio = (int)filter_input(INPUT_POST, 'pIdTipoServicio');
			$pIdDesMed = (int)filter_input(INPUT_POST, 'pIdDesMed');
			
			$pNotasCantidad = filter_input(INPUT_POST, 'pNotasCantidad');
			$pNotasCarga = filter_input(INPUT_POST, 'pNotasCarga');
			$pIdImportador = (int)filter_input(INPUT_POST, 'pIdImportador');

			//$stmt = $conn->prepare("call servicios_insertar('$idEmpresa','$pCodigoTrazabilidad','$pIdCliente','$pIdCliPersonal', UPPER('$pImportador'),'$pIdTipoCarga','$pimo','$pIdDimCon','$pContenedor','$pSelloOriginal','$pSelloNuevo','$pCantidad','$pPeso','$pIdTipoServicio','$pIdDesMed','$pNotasCantidad','$pNotasCarga','$pIdUsuario')");
			$stmt = $conn->prepare("call servicios_insertar('$idEmpresa','$pIdCliente','$pIdCliPersonal', UPPER('$pImportador'),'$pIdTipoCarga','$pimo','$pIdDimCon','$pContenedor','$pSelloOriginal','$pSelloNuevo','$pCantidad','$pPeso','$pIdTipoServicio','$pIdDesMed','$pNotasCantidad','$pNotasCarga','$pIdUsuario',$pIdImportador)");
			$stmt->execute();

			$response = new root_response;
			$row = $stmt->fetch(PDO::FETCH_ASSOC); //Si solo regresa un row la consulta
			// foreach ( $rows as $row ){
			// 	$respuesta = new core_clientes();
			// 	$respuesta->id = $row['Id'];
			// 	$respuesta->nombre = $row['Nombre'];
			// 	$respuesta->patente = $row['Patente'];
			// 	$response->datos[] = $respuesta;
			// 	// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
			// 	// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
			// 	// }
			// }
			$response->transaccion = $row['Transaccion'];  //transaccion contiene el nuevo idServicio
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		case 'serviciosPedimentosInsertar':
			$pIdServicio = filter_input(INPUT_POST, 'pIdServicio');
			$pPedimento = filter_input(INPUT_POST, 'pPedimento');
			$pReferencia = filter_input(INPUT_POST, 'pReferencia');

			$stmt = $conn->prepare("call servicios_pedimentos_insertar('$idEmpresa','$pIdServicio','$pPedimento','$pReferencia')");
			$stmt->execute();

			$response = new root_response;
			$row = $stmt->fetch(PDO::FETCH_ASSOC); //Si solo regresa un row la consulta
			// foreach ( $rows as $row ){
			// 	$respuesta = new core_clientes();
			// 	$respuesta->id = $row['Id'];
			// 	$respuesta->nombre = $row['Nombre'];
			// 	$respuesta->patente = $row['Patente'];
			// 	$response->datos[] = $respuesta;
			// 	// foreach ($row as $field => $value) { // I you want you can right this line like this: foreach($row as $value) {
			// 	// 	echo "<td>" . $value . "</td>"; // I just did not use "htmlspecialchars()" function. 
			// 	// }
			// }
			$response->transaccion = $row['Transaccion'];  //transaccion contiene el nuevo idServicio
			$response->mensaje = $row['Mensaje'];

			echo json_encode($response);
			break;

		default:
			//echo json_encode(system_get_message(SISTEMA_PARAMETRO_NO_RECONOCIDO));
			$response = new root_response;
			$response->transaccion = 0;
			$response->mensaje = "Funcion no reconocida";
			$response->datos = "";
			
			echo json_encode($response);
			break;
	}
?>
