<?php
	if(!isset($_SESSION)) session_start();
	require_once "modelos/cfdi.php";
	require_once "modelos/pagos.php";
	require_once "modelos/bd.php";
	require_once "config.php";
	require_once "ws_conexion.php";
	require_once "cancelacion.php";
	header('Content-Type: application/json');
	
	cancelacion_pendientes_consulta($conn);
	
	function cancelacion_pendientes_consulta($conexion){
		try{
			//Consulta
			$idEmpresa = $_GET['empresa'];
			$tipoSistema = $_GET['sistema'];
			
			$stmt = $conexion->prepare("call facturacion.facturas_noemitidas_consultas('$idEmpresa','$tipoSistema')");
			$stmt->execute();	
				
			$numRegistrosPendientes = $stmt->rowCount();
			$datosEncabezado = [];
			
			if($numRegistrosPendientes > 0) {
				while($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
					$respuesta = new respuesta_pendiente_cancelar();
					
					$respuesta->IdFactura = $row["IdFactura"];
					$respuesta->UUID = $row["UUID"];
					$respuesta->RFC_Emisor = $row["RFC_Emisor"];
					$respuesta->RFC_Receptor = $row["RFC_Receptor"];
					$respuesta->Total = $row["Total"];
					$respuesta->IdEmpresa = $row["IdEmpresa"];
					$respuesta->TipoSistema = $row["TipoSistema"];
					$respuesta->Folio = $row["Folio"];
					$respuesta->TipoFactura = $row["TipoFactura"];
					
					$datosPendientes[] = $respuesta;
					//return json_encode($datosEncabezado);			
				};
				$stmt->closeCursor();
			} else {
				return "No se pudieron obtener los comprobantes pendientes de timbrado";
			}
			
			//Por cada elemento en datosPendientes enviamos una peticion de timbrado
			for ($x = 0; $x < count($datosPendientes); $x++){
				cancelacion_emision($datosPendientes[x]->UUID, $datosPendientes[x]->RFC_Emisor, $datosPendientes[x]->RFC_Receptor, $datosPendientes[x]->Total, $idEmpresa, $tipoSistema, $datosPendientes[x]->IdFactura, $datosPendientes[x]->TipoFactura, $conexion);
			}
		} catch (Exception $e){
			return "Error al consultar los pendientes de timbrado: " . $e;
		}
	}
	
	
	class respuesta_pendiente_cancelar{
		public $IdFactura;
		public $UUID;
		public $RFC_Emisor; 
		public $RFC_Receptor;
		public $Total;
		public $IdEmpresa;
		public $TipoSistema;
		public $Folio;
		public $TipoFactura;
	}
	
?>